unit filefrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, FileCtrl;

type
  TFileForm = class(TForm)
    Panel1: TPanel;
    lblSource: TLabel;
    edSource: TEdit;
    lblDest: TLabel;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    edDest: TComboBox;
    LoadBtn: TSpeedButton;
    OpenDialog: TOpenDialog;
    procedure LoadBtnClick(Sender: TObject);
  private
    { Private declarations }
    Dir : boolean;
  public
    procedure SetMode(d : boolean);
    { Public declarations }
  end;

var
  FileForm: TFileForm;

implementation

uses main;

{$R *.dfm}

procedure TFileForm.SetMode(d : boolean);
begin
  Dir := d;
  if dir then begin
    Caption := 'Add Directory';
  end
  else begin
    Caption := 'Add File';
  end
end;

procedure TFileForm.LoadBtnClick(Sender: TObject);
var s : string;
begin
  if Dir then begin
    if SelectDirectory('Select Directory', ExtractFilePath(MainForm.FileName), s) then
      edSource.Text := ExtractRelativePath(MainForm.FileName, s);
  end
  else begin
    OpenDialog.InitialDir := ExtractFilePath(MainForm.FileName);
    if OpenDialog.Execute then
      edSource.Text := ExtractRelativePath(MainForm.FileName, OpenDialog.FileName);
  end;
end;

end.
