/*
 * Created on 2004. 2. 20.
 */

package net.narusas.daap.server.response;

import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.Playlist;
import net.narusas.daap.server.tag.*;

/**
 * @author Jisung, Ahn
 */
public class PlaylistResponse implements DaapResponse {

	ListTag aply;
	static long[] mper = new long[]{4134910881581252170L, 3430471523209072657L};

	public PlaylistResponse(DaapRequest req, Database _db) {
		Playlist[] playlists = _db.getPlaylists();
		aply = Tag.listTag("aply");
		aply.addTag(Tag.integerTag("mstt", 200));
		aply.addTag(Tag.byteTag("muty", 0));
		aply.addTag(Tag.integerTag("mtco", playlists.length));
		aply.addTag(Tag.integerTag("mrco", playlists.length));
		ListTag mdcl = Tag.listTag("mlcl");
		aply.addTag(mdcl);
		for (int i = 0; i < playlists.length; i++) {
			Playlist playlist = playlists[i];
			long current = System.currentTimeMillis();
			ListTag mlit = Tag.listTag("mlit");
			mdcl.addTag(mlit);
			mlit.addTag(Tag.integerTag("miid", playlist.getUID()));
			mlit.addTag(Tag.stringTag("minm", playlist.getName()));
			mlit.addTag(Tag.integerTag("mimc", playlist.getAllSongs().length));
		}
	}
	public ListTag getResponse() {
		return aply;
	}
}
