/*
 * Created on 2004. 2. 29.
 */

package net.narusas.daap.server.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.Song;
import net.narusas.daap.server.tag.ListTag;

/**
 * @author Administrator
 */
public class MP3Response implements DaapResponse {

	private int _uid;
	private Database _db;
	private MP3DownTag _tag;


	/**
	 * @param req
	 * @param _db
	 */
	public MP3Response(DaapRequest req, Database db) {
		_uid = Integer.parseInt(req.getMP3());
		_db = db;
		_tag = new MP3DownTag(db.getPlaylists()[0].getSong(_uid));
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see net.narusas.daap.server.DaapResponse#getResponse()
	 */
	public ListTag getResponse() {
		return _tag;
	}

	class MP3DownTag extends ListTag {

		private Song _song;


		public MP3DownTag(Song song) {
			super("MP3D");
			_song = song;
		}


		public String getName() {
			return "MP3D";
		}


		public void toDaap(OutputStream out) {
			try {
				InputStream in = _song.getMusicStream();
				byte[] buf = new byte[1024];
				while (true) {
					int r = in.read(buf, 0, 1024);
					if (r == -1) {
						break;
					}
					out.write(buf, 0, r);
				}
				out.flush();
				in.close();
				out.close();
			}
			catch (IOException ex) {
				ex.printStackTrace();
			}
		}


		public boolean isStreaming() {
			return true;
		}
	}
}
