/*
 * Created on 2004. 2. 20.
 */

package net.narusas.daap.server.response;

import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.Playlist;
import net.narusas.daap.server.api.Song;
import net.narusas.daap.server.tag.*;

/**
 * @author Jisung, Ahn
 */
public class DatabaseResponse implements DaapResponse {

	ListTag adbs;

	public DatabaseResponse(DaapRequest req, Database _db) {
		Playlist library = _db.getPlaylists()[0]; // Library
		Song[] songs = library.getAllSongs();
		adbs = Tag.listTag("adbs");
		adbs.addTag(Tag.integerTag("mstt", 200));
		adbs.addTag(Tag.byteTag("muty", 0));
		adbs.addTag(Tag.integerTag("mtco", songs.length));
		adbs.addTag(Tag.integerTag("mrco", songs.length));
		ListTag mdcl = Tag.listTag("mlcl");
		adbs.addTag(mdcl);
		
		for (int i = 0; i < songs.length; i++) {
			Song song = songs[i];
			long current = System.currentTimeMillis();
			ListTag mlit = Tag.listTag("mlit");
			mdcl.addTag(mlit);
			mlit.addTag(Tag.byteTag("mikd", 2));
			mlit.addTag(Tag.byteTag("asdk", 0));// Data kind
			mlit.addTag(Tag.stringTag("minm", song.getName()));
			mlit.addTag(Tag.integerTag("miid", song.getUID()));
			mlit.addTag(Tag.stringTag("asal", song.getAlbum()));
			mlit.addTag(Tag.stringTag("asar", song.getArtist()));
			mlit.addTag(Tag.shortTag("asbr", song.getBitRate())); //bit
			mlit.addTag(Tag.shortTag("asbt", song.getBPM())); //beat
			mlit.addTag(Tag.stringTag("ascm", song.getComment())); //comment
			mlit.addTag(Tag.byteTag("asco", song.getCompilation())); //compilation
			mlit.addTag(Tag.stringTag("ascp", song.getComposer())); //composer
			mlit.addTag(Tag.dateTag("asda", current)); //Added time
			mlit.addTag(Tag.dateTag("asdm", current)); //modified time
			mlit.addTag(Tag.shortTag("asdc", 0)); //Disc count
			mlit.addTag(Tag.shortTag("asdn", 0)); //Disc number
			mlit.addTag(Tag.byteTag("asdb", 0)); //Disabled?
			mlit.addTag(Tag.stringTag("asfm", "mp3")); //Format
			mlit.addTag(Tag.stringTag("asgn", song.getGenre())); // Genre
			mlit.addTag(Tag.stringTag("asdt", "MP3 Audio File")); // Description
			mlit.addTag(Tag.byteTag("asrv", 0)); // song relative volume
			mlit.addTag(Tag.integerTag("assr", song.getSampleRate())); //song sample rate
			mlit.addTag(Tag.integerTag("assz", song.getStreamLength())); //song size
			mlit.addTag(Tag.integerTag("asst", 0)); //songstarttime
			mlit.addTag(Tag.integerTag("assp", 0)); //songstoptime
			mlit.addTag(Tag.integerTag("astm", song.getTime())); //song time
			mlit.addTag(Tag.shortTag("astc", 0)); //song count
			mlit.addTag(Tag.shortTag("astn", 0)); //song number
			mlit.addTag(Tag.byteTag("asur", song.getUserRating())); // song user rating
			mlit.addTag(Tag.shortTag("astn", song.getYear())); //song year
			mlit.addTag(Tag.stringTag("asul", "")); // SOng Data url
		}
	}
	public ListTag getResponse() {
		return adbs;
	}
}
