/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server.tag;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.narusas.daap.server.tag.ByteTag;
import net.narusas.daap.server.tag.IntegerTag;
import net.narusas.daap.server.tag.ListTag;
import net.narusas.daap.server.tag.StringTag;
import net.narusas.daap.server.tag.Tag;

public class TagTest
extends TestCase {
    public void testIntTag() {
        IntegerTag intTag = Tag.integerTag("aaaa", 15);
        Assert.assertEquals((String)"aaaa", (String)intTag.getName());
        Assert.assertEquals((int)12, (int)intTag.length());
        Assert.assertEquals((int)4, (int)intTag.getDataLength());
        Assert.assertEquals((int)0, (int)intTag.getData()[0]);
        Assert.assertEquals((int)0, (int)intTag.getData()[1]);
        Assert.assertEquals((int)0, (int)intTag.getData()[2]);
        Assert.assertEquals((int)15, (int)intTag.getData()[3]);
    }

    public void testStringTag() throws Exception {
        StringTag tag = Tag.stringTag("AAAA", "aaaa");
        Assert.assertEquals((int)12, (int)tag.length());
        Assert.assertEquals((int)4, (int)tag.getDataLength());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("AAAA".getBytes());
        bout.write(TagTest.intTo4Bytes(4));
        bout.write("aaaa".getBytes());
        byte[] src = tag.toDaap();
        byte[] target = bout.toByteArray();
        int i = 0;
        while (i < target.length) {
            Assert.assertEquals((String)(String.valueOf(i) + "th test"), (byte)target[i], (byte)src[i]);
            ++i;
        }
        tag = Tag.stringTag("AAAA", "");
        Assert.assertEquals((int)8, (int)tag.length());
        Assert.assertEquals((int)0, (int)tag.getDataLength());
        byte[] daap = tag.toDaap();
        Assert.assertEquals((int)8, (int)daap.length);
    }

    public void testListTag() throws IOException {
        ListTag list = Tag.listTag("adbs");
        Assert.assertEquals((int)8, (int)list.length());
        Assert.assertEquals((int)0, (int)list.getDataLength());
        Assert.assertNotNull((Object)list.getData());
        Assert.assertEquals((int)0, (int)list.getData().length);
        IntegerTag intTag = Tag.integerTag("aaaa", 15);
        list.addTag(intTag);
        Assert.assertEquals((int)20, (int)list.length());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("adbs".getBytes());
        bout.write(TagTest.intTo4Bytes(12));
        bout.write("aaaa".getBytes());
        bout.write(TagTest.intTo4Bytes(4));
        bout.write(TagTest.intTo4Bytes(15));
        byte[] src = list.toDaap();
        byte[] target = bout.toByteArray();
        int i = 0;
        while (i < target.length) {
            Assert.assertEquals((String)(String.valueOf(i) + "th test"), (byte)target[i], (byte)src[i]);
            ++i;
        }
    }

    public void testListInList() throws IOException {
        ListTag parentList = Tag.listTag("adbs");
        ListTag childList = Tag.listTag("avdb");
        parentList.addTag(childList);
        IntegerTag intTag = Tag.integerTag("aaaa", 15);
        childList.addTag(intTag);
        Assert.assertEquals((int)28, (int)parentList.length());
        Assert.assertEquals((int)20, (int)childList.length());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("adbs".getBytes());
        bout.write(TagTest.intTo4Bytes(20));
        bout.write("avdb".getBytes());
        bout.write(TagTest.intTo4Bytes(12));
        bout.write("aaaa".getBytes());
        bout.write(TagTest.intTo4Bytes(4));
        bout.write(TagTest.intTo4Bytes(15));
        byte[] src = parentList.toDaap();
        byte[] target = bout.toByteArray();
        int i = 0;
        while (i < target.length) {
            Assert.assertEquals((String)(String.valueOf(i) + "th test"), (byte)target[i], (byte)src[i]);
            ++i;
        }
    }

    public void testSubstring() {
        String param = "asda=zzzz";
        String name = param.substring(0, param.indexOf("="));
        String value = param.substring(param.indexOf("=") + 1);
        Assert.assertEquals((String)"asda", (String)name);
        Assert.assertEquals((String)"zzzz", (String)value);
    }

    public void testByte() {
        ByteTag tag = Tag.byteTag("abcd", 0);
        Assert.assertEquals((int)1, (int)tag.getDataLength());
        Assert.assertEquals((int)9, (int)tag.length());
        Assert.assertEquals((int)9, (int)tag.toDaap().length);
    }

    public static byte[] intTo4Bytes(int i) {
        byte[] b = new byte[4];
        b[3] = (byte)(i & 0xFF);
        b[2] = (byte)(i >>> 8 & 0xFF);
        b[1] = (byte)(i >>> 16 & 0xFF);
        b[0] = (byte)(i >>> 24 & 0xFF);
        return b;
    }
}

