/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.zip.GZIPOutputStream;
import net.narusas.daap.server.DaapRequest;
import net.narusas.daap.server.DaapResponse;
import net.narusas.daap.server.JDaapServer;
import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.UpdateListener;
import net.narusas.daap.server.response.ContentCodeResponse;
import net.narusas.daap.server.response.DatabaseResponse;
import net.narusas.daap.server.response.DatabasesResponse;
import net.narusas.daap.server.response.LoginResponse;
import net.narusas.daap.server.response.MP3Response;
import net.narusas.daap.server.response.PlaylistResponse;
import net.narusas.daap.server.response.ServerInfoResponse;
import net.narusas.daap.server.response.SongsResponse;
import net.narusas.daap.server.response.UpdateResponse;
import net.narusas.daap.server.tag.ListTag;

public class DaapSession
extends Thread
implements UpdateListener {
    private Socket requestorSocket;
    private SimpleDateFormat df;
    private static final String SERVER_INFO = "/server-info";
    private static final String LOGIN = "/login";
    private static final String CONTENT_CODES = "/content-codes";
    private static final String UPDATE = "/update";
    private static final String DATABASES_INFO = "/databases?";
    private static final String DATABASES_DATA = "/databases/";
    private static final String CONTAINERS_PLAYLIST = "/containers?";
    private static final String CONTAINERS_MUSIC = "/containers/";
    private static final String SONG_LIST = "/items?";
    private static final String GET_SONG = "/items/";
    private static final String CRLF = "\r\n";
    private Database _db;
    private int _session;
    private int _revision;
    private int _oldRevision;
    private static int _nexSession = 1;
    private JDaapServer _server;

    public DaapSession(JDaapServer server, Socket s, Database db) {
        this._server = server;
        this._db = db;
        this.requestorSocket = s;
        this.df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        this._session = _nexSession++;
        this._oldRevision = this._revision = 1;
    }

    public void run() {
        this.setName("Daap session");
        try {
            BufferedInputStream in = new BufferedInputStream(this.requestorSocket.getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(this.requestorSocket.getOutputStream());
            while (true) {
                DaapRequest req;
                DaapResponse res;
                ListTag tag;
                if ((tag = (res = this.getMatchedResponse(req = new DaapRequest(in))).getResponse()) == null) {
                    continue;
                }
                String resHTTP = this.getResonseHeader(tag);
                ((OutputStream)out).write(resHTTP.getBytes());
                if (tag.isStreaming()) {
                    tag.toDaap(out);
                    continue;
                }
                ((OutputStream)out).write(tag.toDaap());
                ((OutputStream)out).flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._server.removeSession(this);
            return;
        }
    }

    private byte[] gzip(byte[] bs) {
        byte[] result = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            GZIPOutputStream gzipOut = new GZIPOutputStream(bout);
            gzipOut.write(bs);
            gzipOut.flush();
            result = bout.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getResonseHeader(ListTag tag) {
        StringBuffer buf = new StringBuffer();
        buf.append("HTTP/1.1 200 OK\r\n");
        buf.append("Date: Sat, 14 Feb 2004 17:42:33 GMT\r\n");
        buf.append("DAAP-Server: narusasDaapServer/1.0 (Java)\r\n");
        buf.append("Accept-Ranges: bytes\r\n");
        buf.append("Content-Length: " + tag.length() + CRLF);
        buf.append("Content-Type: application/x-dmap-tagged\r\n");
        buf.append(CRLF);
        return buf.toString();
    }

    private DaapResponse getMatchedResponse(DaapRequest req) {
        String res = req.getResponse();
        if ("MSRV".equals(res)) {
            return new ServerInfoResponse(req, this._db);
        }
        if ("MCCR".equals(res)) {
            return new ContentCodeResponse(req, this._db);
        }
        if ("MLOG".equals(res)) {
            return new LoginResponse(req, this._db, this._session);
        }
        if ("MUPD".equals(res)) {
            return new UpdateResponse(req, this._db, this._revision);
        }
        if ("AVDB".equals(res)) {
            return new DatabasesResponse(req, this._db);
        }
        if ("ADBS".equals(res)) {
            return new DatabaseResponse(req, this._db);
        }
        if ("APLY".equals(res)) {
            return new PlaylistResponse(req, this._db);
        }
        if ("APSO".equals(res)) {
            return new SongsResponse(req, this._db);
        }
        if ("MP3D".equals(res)) {
            return new MP3Response(req, this._db);
        }
        return null;
    }

    public void updated(Database evetSource) {
        ++this._revision;
    }
}

