/*
 * Decompiled with CFR 0.152.
 */
package net.narusas.daap.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import net.narusas.daap.server.util.Utils;

public class DaapRequest {
    private int _contentLength;
    private boolean _isGzip;
    private String _method;
    private String _uri;
    private String _http;
    Properties params = new Properties();
    private ArrayList _meta;
    private String _sessionId;
    private int _revision;
    private String _response;
    private static final String SERVER_INFO = "/server-info";
    private static final String LOGIN = "/login";
    private static final String CONTENT_CODES = "/content-codes";
    private static final String UPDATE = "/update";
    private static final String DATABASES_INFO = "/databases?";
    private static final String DATABASES_DATA = "/databases/";
    private static final String CONTAINERS_PLAYLIST = "/containers?";
    private static final String CONTAINERS_MUSIC = "/containers/";
    private static final String SONG_LIST = "/items?";
    private static final String GET_SONG = "/items/";
    private String _database;
    private String _container;
    private String _mp3;
    private boolean _update;

    public DaapRequest(InputStream in) throws Exception {
        this.parse(in);
    }

    public int getContentLengt() {
        return this._contentLength;
    }

    public boolean containMeta(String targetMeta) {
        return this._meta.contains(targetMeta);
    }

    public String[] getMetas() {
        return this._meta.size() == 0 ? null : this._meta.toArray(new String[0]);
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public int getRevision() {
        return this._revision;
    }

    public String getResponse() {
        return this._response;
    }

    private void parse(InputStream in) throws Exception {
        String line;
        this._contentLength = 0;
        this._isGzip = false;
        boolean isFirstLine = true;
        do {
            line = this.readLine(in);
            if (isFirstLine) {
                isFirstLine = false;
                StringTokenizer tokens = new StringTokenizer(line);
                this._method = tokens.nextToken();
                this._uri = tokens.nextToken();
                this._http = tokens.nextToken();
                this.parseURI(this._uri);
            }
            if (line.startsWith("Content-Length:")) {
                this._contentLength = Integer.parseInt(line.substring("Content-Length:".length()).trim());
            }
            if (!line.startsWith("Content-Encoding: gzip")) continue;
            this._isGzip = true;
        } while (!"".equals(line));
    }

    private void parseURI(String uri) {
        this.parseRequestedURI(uri);
        this.parseParams(uri);
    }

    private void parseRequestedURI(String uri) {
        String requested = null;
        requested = uri.indexOf("?") != -1 ? uri.substring(0, uri.indexOf("?") + 1) : uri;
        StringTokenizer tokens = new StringTokenizer(requested, "/?");
        if (requested.equalsIgnoreCase(SERVER_INFO)) {
            this._response = "MSRV";
        } else if (requested.equalsIgnoreCase(LOGIN)) {
            this._response = "MLOG";
        } else if (requested.equalsIgnoreCase(CONTENT_CODES)) {
            this._response = "MCCR";
        } else if (requested.startsWith(UPDATE)) {
            this._response = requested.indexOf("delta") == -1 ? "MUPD" : "BLANK()";
        } else if (requested.startsWith(DATABASES_INFO)) {
            this._response = "AVDB";
        } else if (requested.startsWith(DATABASES_DATA)) {
            if (requested.indexOf(SONG_LIST) > -1 && requested.indexOf(CONTAINERS_MUSIC) == -1) {
                this._response = "ADBS";
                tokens.nextToken();
                this._database = tokens.nextToken();
            } else if (requested.indexOf(CONTAINERS_PLAYLIST) > -1) {
                this._response = "APLY";
                tokens.nextToken();
                this._database = tokens.nextToken();
            } else if (requested.indexOf(CONTAINERS_MUSIC) > -1 && requested.indexOf(SONG_LIST) > -1) {
                this._response = "APSO";
                tokens.nextToken();
                this._database = tokens.nextToken();
                tokens.nextToken();
                this._container = tokens.nextToken();
            } else if (requested.indexOf(GET_SONG) > -1) {
                this._response = "MP3D";
                tokens.nextToken();
                this._database = tokens.nextToken();
                tokens.nextToken();
                String temp = tokens.nextToken();
                this._mp3 = temp.substring(0, temp.indexOf(46));
            }
        }
    }

    private void parseParams(String uri) {
        this._update = false;
        if (uri.indexOf("?") == -1) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(uri.substring(uri.indexOf("?") + 1), "&");
        while (tokens.hasMoreTokens()) {
            String param = tokens.nextToken();
            String name = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1);
            this.params.setProperty(name, value);
            if ("meta".equals(name)) {
                this.parseMeta(value);
            }
            if ("session-id".equals(name)) {
                this._sessionId = value;
            }
            if ("revision-number".equals(name)) {
                this._revision = Integer.parseInt(value);
            }
            if (!"delta".equals(name)) continue;
            this._update = true;
        }
    }

    private void parseMeta(String metaValue) {
        this._meta = new ArrayList();
        StringTokenizer tokens = new StringTokenizer(metaValue, ",");
        while (tokens.hasMoreTokens()) {
            this._meta.add(tokens.nextToken());
        }
    }

    private String readLine(InputStream in) throws IOException {
        return Utils.readLine(in, new byte[1024]);
    }

    public String getDatabase() {
        return this._database;
    }

    public String getPlaylist() {
        return this._container;
    }

    public String getMP3() {
        return this._mp3;
    }

    public boolean isNewUpdate() {
        return this._update;
    }
}

