import java.util.Vector;


public class ErrorReporter {

  public Vector<ErrorItem> errors;
  int numErrors;

  public class ErrorItem{
      public String msg;
      public String tok;
      public SourcePosition pos;
      public ErrorItem(String message,String tokenName,SourcePosition pos)
      {
          this.msg = message;
          this.tok = tokenName;
          this.pos = pos;
      }
  }
  
  ErrorReporter() {
    numErrors = 0;
    errors= new Vector();
  }

  public void reportError(String message, String tokenName, SourcePosition pos) {
    System.out.print ("ERROR: ");
    StringBuffer out = new StringBuffer();
    for (int p = 0; p < message.length(); p++)
    if (message.charAt(p) == '%')
      out.append(tokenName);
    else
      out.append(message.charAt(p));
    System.out.print(out.toString());
    System.out.println(" <line: " + pos.start + "~" + pos.finish + ">");
    numErrors++;
    errors.addElement(new ErrorItem(out.toString(),tokenName,pos));
  }

}