

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;


public class Drawer {

  private DrawerFrame frame;
  private DrawerPanel panel;

  private ASTProgramDeclaration theAST;
  private DrawingTree theDrawing;

  // Draw the AST representing a complete program.

  public void draw(ASTProgramDeclaration ast) {
    theAST = ast;
    panel = new DrawerPanel(this);
    frame = new DrawerFrame(panel);

    Font font = new Font("SansSerif", Font.PLAIN, 12);
    frame.setFont(font);

    FontMetrics fontMetrics = frame.getFontMetrics(font);

    LayoutVisitor layout = new LayoutVisitor(fontMetrics);
    theDrawing = (DrawingTree) theAST.jjtAccept(layout, null);
    theDrawing.position(new Point(2048, 10));
    
    panel.scrollRectToVisible(new Rectangle(1500,0,0,0));
    frame.setExtendedState(frame.MAXIMIZED_BOTH);
    frame.setVisible(true);
    
  }

  public void paintAST (Graphics g) {
    g.setColor(panel.getBackground());
    Dimension d = panel.getSize();
    g.fillRect(0, 0, d.width, d.height);

    if (theDrawing != null) {
      theDrawing.paint(g);
    }
  }
}
