// SocketTCP.h : Declaration of the CSocketTCP

#pragma once

#include "resource.h"       // main symbols
#include <asptlb.h>         // Active Server Pages Definitions

#include "cssock.h"
#include "cssockCP.h"
#include "tcpconn.hpp"



// CSocketTCP

class ATL_NO_VTABLE CSocketTCP :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CSocketTCP, &CLSID_SocketTCP>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CSocketTCP>,
	public CProxy_ISocketTCPEvents<CSocketTCP>,
	public IDispatchImpl<ISocketTCP, &IID_ISocketTCP, &LIBID_cssockLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CSocketTCP()
	{
		m_bOnStartPageCalled = FALSE;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SOCKETTCP)


BEGIN_COM_MAP(CSocketTCP)
	COM_INTERFACE_ENTRY(ISocketTCP)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
END_COM_MAP()

BEGIN_CONNECTION_POINT_MAP(CSocketTCP)
	CONNECTION_POINT_ENTRY(__uuidof(_ISocketTCPEvents))
END_CONNECTION_POINT_MAP()
// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

// ISocketTCP
public:
	//Active Server Pages Methods
	STDMETHOD(OnStartPage)(IUnknown* IUnk);
	STDMETHOD(OnEndPage)();
private:
	CComPtr<IRequest> m_piRequest;					//Request Object
	CComPtr<IResponse> m_piResponse;				//Response Object
	CComPtr<ISessionObject> m_piSession;			//Session Object
	CComPtr<IServer> m_piServer;					//Server Object
	CComPtr<IApplicationObject> m_piApplication;	//Application Object
	BOOL m_bOnStartPageCalled;						//OnStartPage successful?
	tcpconn tcp;
	STDMETHOD(Connect)(BSTR host, USHORT port, VARIANT_BOOL* retval);
	STDMETHOD(SendText)(BSTR data, VARIANT_BOOL* retval);
	STDMETHOD(GetText)(USHORT bytes, BSTR* retval);
};

OBJECT_ENTRY_AUTO(__uuidof(SocketTCP), CSocketTCP)
