#!/usr/bin/python
"""
 CSCM2 TBSP, CSCP

 Copyright (C) 2008, D&SOFT
 CoolSMS <help@coolsms.co.kr>
"""
import sys,string

def tbsp_parse(tbspstr):
	tbsparr = string.split(tbspstr, "\n")
	property = {}

	for line in tbsparr:
		element = string.split(line, ":")
		if len(element) < 2:
			continue
		name = element[0]
		value = element[1]

		if name == "MESSAGE":
			if property.has_key(name):
				property[name] = property[name] + "\n" + value
			else:
				property[name] = value
		else:
			property[name] = value
	return property

def tbsp_build(tbsp):
	tbspstr = ""

	for key in tbsp.keys():
		if key == "MESSAGE":
			msgarr = string.split(tbsp[key], "\n")
			for line in msgarr:
				tbspstr = tbspstr + key + ":" + line + "\n"
		else:
			tbspstr = tbspstr + key + ":" + tbsp[key] + "\n"
	return tbspstr

def cscp_read(sock):
	CSCP_VERSION_SIZE = 7
	CSCP_BODYLEN_SIZE = 6

	version = sock.recv(CSCP_VERSION_SIZE)
	bodylen = sock.recv(CSCP_BODYLEN_SIZE)
	bodylen = int(bodylen)
	
	if bodylen > 0:
		body = sock.recv(bodylen)

	return body

def cscp_build(cscpstr):
	capsule = "CSCP1.0"
	capsule = capsule + "%6d" % len(cscpstr)
	capsue = capsule + cscpstr

	return capsue
