/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import net.hero.engine.base.Image;
import net.hero.engine.style.EnumAlignHorizontal;
import net.hero.engine.style.EnumAlignVertical;
import net.hero.engine.style.EnumImageFillStyle;
import net.hero.engine.style.EnumImageSource;
import net.hero.engine.style.Style;

public class ImageStyle
extends Style
implements Image {
    public static final String IMAGE_SOURCE = "image-source";
    public static final String IMAGE_PATH = "image-path";
    public static final String IMAGE_DATA = "image-data";
    public static final String IMAGE_FILL = "image-fill";
    public static final String IMAGE_ALIGN_VERTICAL = "image-align-vertical";
    public static final String IMAGE_ALIGN_HORIZONTAL = "image-align-horizontal";
    public static final String[] ATTRIBUTE_NAMES = new String[]{"image-source", "image-path", "image-data", "image-fill", "image-align-vertical", "image-align-horizontal"};

    public ImageStyle() {
        this.attributes.addAttribute(IMAGE_SOURCE, EnumImageSource.PATH);
        this.attributes.addAttribute(IMAGE_PATH, "");
        this.attributes.addAttribute(IMAGE_DATA, "");
        this.attributes.addAttribute(IMAGE_FILL, EnumImageFillStyle.NONE);
        this.attributes.addAttribute(IMAGE_ALIGN_VERTICAL, EnumAlignVertical.TOP);
        this.attributes.addAttribute(IMAGE_ALIGN_HORIZONTAL, EnumAlignHorizontal.LEFT);
    }

    @Override
    public String getFamilyName() {
        return "image";
    }

    @Override
    public String[] getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public int getImageSource() {
        return this.getAttribute(IMAGE_SOURCE).toInt();
    }

    @Override
    public String getImagePath() {
        return this.getAttribute(IMAGE_PATH).toString();
    }

    @Override
    public String getImageData() {
        return this.getAttribute(IMAGE_DATA).toString();
    }

    @Override
    public int getImageFill() {
        return this.getAttribute(IMAGE_FILL).toInt();
    }

    @Override
    public int getImageAlignVertical() {
        return this.getAttribute(IMAGE_ALIGN_VERTICAL).toInt();
    }

    @Override
    public int getImageAlignHorizontal() {
        return this.getAttribute(IMAGE_ALIGN_HORIZONTAL).toInt();
    }

    @Override
    public void setImageSource(int source) {
        this.getAttribute(IMAGE_SOURCE).setValue(source);
    }

    @Override
    public void setImagePath(String path) {
        this.getAttribute(IMAGE_PATH).setValue(path);
    }

    @Override
    public void setImageData(String data) {
        this.getAttribute(IMAGE_DATA).setValue(data);
    }

    @Override
    public void setImageFill(int fill) {
        this.getAttribute(IMAGE_FILL).setValue(fill);
    }

    @Override
    public void setImageAlignVertical(int align) {
        this.getAttribute(IMAGE_ALIGN_VERTICAL).setEnum(align);
    }

    @Override
    public void setImageAlignHorizontal(int align) {
        this.getAttribute(IMAGE_ALIGN_HORIZONTAL).setEnum(align);
    }
}

