/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.Pair;
import net.hero.engine.style.BackGroundStyle;
import net.hero.engine.style.BorderStyle;
import net.hero.engine.style.FontStyle;
import net.hero.engine.style.ImageStyle;
import net.hero.engine.style.LineStyle;
import net.hero.engine.style.PaddingStyle;
import net.hero.engine.style.SectionStyle;
import net.hero.engine.style.Style;
import net.hero.engine.style.VisibleStyle;

public class FactoryStyle {
    private static FactoryStyle singletonFactory = new FactoryStyle();
    private static Map<String, Pair<String, Integer>> mapAutoStyleNames = new HashMap<String, Pair<String, Integer>>();

    static {
        mapAutoStyleNames.put("background", new Pair<String, Integer>("background", 1));
        mapAutoStyleNames.put("border", new Pair<String, Integer>("border", 1));
        mapAutoStyleNames.put("font", new Pair<String, Integer>("font", 1));
        mapAutoStyleNames.put("image", new Pair<String, Integer>("image", 1));
        mapAutoStyleNames.put("padding", new Pair<String, Integer>("padding", 1));
        mapAutoStyleNames.put("section", new Pair<String, Integer>("section", 1));
        mapAutoStyleNames.put("visible", new Pair<String, Integer>("visible", 1));
    }

    private FactoryStyle() {
    }

    public static FactoryStyle getInstance() {
        return singletonFactory;
    }

    public Style createStyle(String family) {
        String styleName = "unnamed";
        Pair<String, Integer> autoStyleName = mapAutoStyleNames.get(family);
        if (autoStyleName != null) {
            styleName = String.valueOf((String)autoStyleName.first) + String.valueOf(autoStyleName.second);
            autoStyleName.second = (Integer)autoStyleName.second + 1;
        }
        return this.createStyle(family, styleName);
    }

    public Style createStyle(String family, String name) {
        Style style = null;
        if ((family = family.toLowerCase()).equals("background")) {
            style = new BackGroundStyle();
        } else if (family.equals("border")) {
            style = new BorderStyle();
        } else if (family.equals("font")) {
            style = new FontStyle();
        } else if (family.equals("image")) {
            style = new ImageStyle();
        } else if (family.equals("padding")) {
            style = new PaddingStyle();
        } else if (family.equals("section")) {
            style = new SectionStyle();
        } else if (family.equals("visible")) {
            style = new VisibleStyle();
        } else if (family.equals("line")) {
            style = new LineStyle();
        }
        if (style != null) {
            style.setName(name);
        }
        return style;
    }
}

