/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.awt.Color;
import net.hero.engine.base.BackGround;
import net.hero.engine.style.EnumBackGroundFillStyle;
import net.hero.engine.style.EnumBackGroundStyle;
import net.hero.engine.style.Style;

public class BackGroundStyle
extends Style
implements BackGround {
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BACKGROUND_STYLE = "background-style";
    public static final String BACKGROUND_FILLCOLOR = "background-fill-color";
    public static final String BACKGROUND_FILLSTYLE = "background-fill-style";
    public static final String[] ATTRIBUTE_NAMES = new String[]{"background-color", "background-style", "background-fill-color", "background-fill-style"};

    public BackGroundStyle() {
        this.attributes.addAttribute(BACKGROUND_COLOR, new Color(255, 255, 255));
        this.attributes.addAttribute(BACKGROUND_STYLE, EnumBackGroundStyle.TRANSPARENT);
        this.attributes.addAttribute(BACKGROUND_FILLCOLOR, new Color(255, 255, 255));
        this.attributes.addAttribute(BACKGROUND_FILLSTYLE, EnumBackGroundFillStyle.NONE);
    }

    @Override
    public String getFamilyName() {
        return "background";
    }

    @Override
    public String[] getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Color getBackGroundColor() {
        return (Color)this.getAttribute(BACKGROUND_COLOR).getValue();
    }

    @Override
    public int getBackGroundStyle() {
        return this.getAttribute(BACKGROUND_STYLE).toInt();
    }

    @Override
    public Color getBackGroundFillColor() {
        return (Color)this.getAttribute(BACKGROUND_FILLCOLOR).getValue();
    }

    @Override
    public int getBackGroundFillStyle() {
        return this.getAttribute(BACKGROUND_FILLSTYLE).toInt();
    }

    @Override
    public void setBackGroundColor(Color color) {
        this.getAttribute(BACKGROUND_COLOR).setValue(color);
    }

    @Override
    public void setBackGroundStyle(int style) {
        this.getAttribute(BACKGROUND_STYLE).setEnum(style);
    }

    @Override
    public void setBackGroundFillColor(Color color) {
        this.getAttribute(BACKGROUND_FILLCOLOR).setValue(color);
    }

    @Override
    public void setBackGroundFillStyle(int style) {
        this.getAttribute(BACKGROUND_FILLSTYLE).setEnum(style);
    }
}

