/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hero.engine.style.TraitEnum;

public class Attribute {
    private String name;
    private Object value;

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Attribute clone() {
        return new Attribute(this.getName(), this.getValue());
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueString() {
        return this.toString();
    }

    public void setValue(Object value) {
        if (this.value instanceof Color) {
            Pattern c;
            Matcher m;
            if (value instanceof Color) {
                this.value = value;
            } else if (value instanceof String && (m = (c = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)")).matcher((String)value)).matches()) {
                this.value = new Color(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
            }
        } else if (this.value instanceof TraitEnum) {
            if (value instanceof TraitEnum) {
                this.value = value;
            } else if (value instanceof String) {
                this.value = ((TraitEnum)this.value).enumOf((String)value);
            } else if (value instanceof Integer) {
                this.value = ((TraitEnum)this.value).enumOf((Integer)value);
            }
        } else {
            this.value = this.value instanceof Boolean ? (value instanceof String ? (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("1") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (value instanceof Integer ? ((Integer)value == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : value)) : value;
        }
    }

    public void setEnum(int enumValue) {
        if (this.value instanceof TraitEnum) {
            this.value = ((TraitEnum)this.value).enumOf(enumValue);
        }
    }

    public boolean equals(Attribute attribute) {
        if (!this.getName().equals(attribute.getName())) {
            return false;
        }
        return this.getValue().equals(attribute.getValue());
    }

    public String toString() {
        if (this.value instanceof Color) {
            return "rgb(" + ((Color)this.value).getRed() + "," + ((Color)this.value).getGreen() + "," + ((Color)this.value).getBlue() + ")";
        }
        if (this.value instanceof TraitEnum) {
            return ((TraitEnum)this.value).getName();
        }
        return String.valueOf(this.value);
    }

    public int toInt() {
        return Integer.parseInt(this.toString());
    }
}

