/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.section;

import java.util.ArrayList;
import net.hero.engine.common.context.Context;
import net.hero.engine.content.instance.InstanceGroup;
import net.hero.engine.data.resultset.Result;
import net.hero.engine.document.control.Control;
import net.hero.engine.document.control.InstanceInfo;
import net.hero.engine.document.section.Section;
import net.hero.engine.processing.EngineCommandAddSection;
import net.hero.engine.processing.EngineCommandCollection;
import net.hero.engine.style.StyleManager;
import net.hero.engine.style.conditional.EvaluationStyleVisible;

public class SectionNormal
extends Section {
    protected ArrayList<Control> listControl = new ArrayList();

    protected SectionNormal() {
    }

    public static SectionNormal createControl(StyleManager styleManager) {
        SectionNormal section = new SectionNormal();
        section.visible = styleManager.getDefaultStyleVisible();
        return section;
    }

    @Override
    public String getFamilyName() {
        return "textbox";
    }

    @Override
    public EngineCommandCollection createCommand(Context ctx, Result result) {
        if (this.getHeight() == 0) {
            return null;
        }
        if (this.getConditionalStyle() != null) {
            EvaluationStyleVisible styleVisible = new EvaluationStyleVisible();
            if (this.getVisible()) {
                int a = 10;
                ++a;
            }
            styleVisible.setVisible(this.getVisible());
            this.getConditionalStyle().applyConditionStyle(styleVisible, ctx);
            if (!styleVisible.getVisible()) {
                return null;
            }
        } else if (!this.getVisible()) {
            return null;
        }
        EngineCommandCollection listCommand = new EngineCommandCollection();
        listCommand.add(new EngineCommandAddSection(result, this));
        return listCommand;
    }

    @Override
    public InstanceInfo[] createInstance(Context ctx, StyleManager styleManager) {
        InstanceInfo[] listInstanceInfo = new InstanceInfo[]{new InstanceInfo()};
        InstanceGroup instanceGroup = InstanceGroup.createInstance(styleManager);
        listInstanceInfo[0].setInstance(instanceGroup);
        listInstanceInfo[0].setControl(this);
        instanceGroup.getRect().set(this.getRect());
        for (Control control : this.listControl) {
            InstanceInfo[] listInstanceInfoChild = control.createInstance(ctx, styleManager);
            if (listInstanceInfoChild == null) continue;
            InstanceInfo[] instanceInfoArray = listInstanceInfoChild;
            int n = listInstanceInfoChild.length;
            int n2 = 0;
            while (n2 < n) {
                InstanceInfo instanceInfo = instanceInfoArray[n2];
                int dx = this.getRect().left;
                int dy = this.getRect().top;
                instanceGroup.getRect().offset(dx, dy);
                instanceGroup.addInstance(instanceInfo.getInstance());
                ++n2;
            }
        }
        return listInstanceInfo;
    }

    public int getControlCount() {
        return this.listControl.size();
    }

    public Control getControl(int i) {
        return this.listControl.get(i);
    }

    public Control[] getAllControl() {
        Control[] instances = new Control[this.listControl.size()];
        return this.listControl.toArray(instances);
    }

    public void addControl(Control control) {
        this.listControl.add(control);
    }
}

