/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.control;

import net.hero.engine.document.control.Control;
import net.hero.engine.document.control.ControlCommon;
import net.hero.engine.document.control.ControlGroup;
import net.hero.engine.document.control.ControlLabel;
import net.hero.engine.document.control.ControlLine;
import net.hero.engine.document.control.ControlShape;
import net.hero.engine.document.control.ControlSubReport;
import net.hero.engine.document.control.ControlTable;
import net.hero.engine.document.control.ControlTableCell;
import net.hero.engine.document.section.SectionNormal;
import net.hero.engine.document.section.SectionSubReport;
import net.hero.engine.style.StyleManager;

public class FactoryControl {
    private static FactoryControl singletonFactory = new FactoryControl();

    private FactoryControl() {
    }

    public static FactoryControl getInstance() {
        return singletonFactory;
    }

    public Control createControl(String controlType, String controlName, StyleManager styleManager) {
        ControlCommon control = null;
        if ((controlType = controlType.toLowerCase()).equals("textbox")) {
            control = ControlLabel.createControl(styleManager);
        } else if (controlType.equals("line")) {
            control = ControlLine.createControl(styleManager);
        } else if (controlType.equals("shape")) {
            control = ControlShape.createControl(styleManager);
        } else if (controlType.equals("table")) {
            control = ControlTable.createControl(styleManager);
        } else if (controlType.equals("table.cell")) {
            control = ControlTableCell.createControl(styleManager);
        } else if (controlType.equals("section.normal")) {
            control = SectionNormal.createControl(styleManager);
        } else if (controlType.equals("section.subreport")) {
            control = SectionSubReport.createControl(styleManager);
        } else if (controlType.equals("group")) {
            control = ControlGroup.createControl(styleManager);
        } else if (controlType.equals("subreport")) {
            control = ControlSubReport.createControl(styleManager);
        }
        return control;
    }
}

