/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.resultset;

import java.util.Map;
import java.util.Vector;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.resultset.Result;
import net.hero.engine.data.resultset.ResultIndex;
import net.hero.engine.data.resultset.ResultSet;

public class ResultSetMem
implements ResultSet {
    protected DataSet dataset = null;
    protected Vector<String> listDatas = new Vector();
    protected int rowCount = 0;

    private ResultSetMem() {
    }

    public ResultSetMem(DataSet dataset) {
        this.dataset = dataset;
    }

    @Override
    public DataSet getDataSet() {
        return null;
    }

    @Override
    public int addString(String[] data) {
        int columncount = this.dataset.getDataSetMeta().getColumnCount();
        if (columncount == 0) {
            return 0;
        }
        int datalength = data.length;
        if (datalength > columncount) {
            datalength = columncount;
        }
        int i = 0;
        while (i < datalength) {
            this.listDatas.add(data[i]);
            ++i;
        }
        if (datalength < columncount) {
            i = 0;
            while (i < columncount - datalength) {
                this.listDatas.add("");
                ++i;
            }
        }
        ++this.rowCount;
        return this.getRowCount();
    }

    public int addString(Map<String, String> data) {
        return this.getRowCount();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getString(int row, int column) {
        int columncount = this.dataset.getDataSetMeta().getColumnCount();
        int index = row * columncount + column;
        if (index >= this.listDatas.size()) {
            return "XXX";
        }
        return this.listDatas.elementAt(row * columncount + column);
    }

    @Override
    public Result[] getResults() {
        int rowcount = this.getRowCount();
        Result[] resultrows = new Result[this.getRowCount()];
        int i = 0;
        while (i < rowcount) {
            resultrows[i] = new ResultIndex(this, i);
            ++i;
        }
        return resultrows;
    }
}

