/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.hero.engine.common.context.Context;
import net.hero.engine.data.field.Field;
import net.hero.engine.data.field.FieldSystem;
import net.hero.engine.data.field.FieldUnSupported;

public class FieldManager {
    private FieldManager parentFieldManager = null;
    private Map<String, Vector<Field>> mapField = new HashMap<String, Vector<Field>>();

    public FieldManager() {
        this.addField(FieldSystem.PageNumber);
        this.addField(FieldSystem.PageCount);
        this.addField(FieldSystem.PagePageNofM);
        this.addField(FieldSystem.RecordNumber);
        this.addField(FieldSystem.RecordCount);
        this.addField(FieldSystem.PrintDate);
    }

    public FieldManager(FieldManager parent) {
        this.parentFieldManager = parent;
        this.addField(FieldSystem.PageNumber);
        this.addField(FieldSystem.PageCount);
        this.addField(FieldSystem.PagePageNofM);
        this.addField(FieldSystem.RecordNumber);
        this.addField(FieldSystem.RecordCount);
        this.addField(FieldSystem.PrintDate);
    }

    public void addField(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Cannot set a null Field");
        }
        String fieldType = field.getType();
        Vector<Field> fields = this.getFields(fieldType);
        if (fields == null) {
            fields = new Vector();
            this.mapField.put(fieldType, fields);
        }
        if (!fields.contains(field)) {
            fields.add(field);
        }
    }

    public Field getField(String fieldType, int i) {
        Vector<Field> fields = this.getFields(fieldType = fieldType.trim());
        if (fields == null) {
            return new FieldUnSupported();
        }
        Field field = fields.elementAt(i);
        if (field == null) {
            return new FieldUnSupported();
        }
        return field;
    }

    public Field getField(String fieldType, String fieldName) {
        fieldType = fieldType.trim();
        fieldName = fieldName.trim();
        Vector<Field> fields = this.getFields(fieldType);
        if (fields == null) {
            FieldUnSupported field = new FieldUnSupported(fieldName);
            return field;
        }
        for (Field field : fields) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return new FieldUnSupported(fieldName);
    }

    public Field getField(String formattedFieldName) {
        formattedFieldName = formattedFieldName.trim();
        Vector<Field> fields = this.getAllFields();
        if (fields == null) {
            if (this.parentFieldManager != null) {
                return this.parentFieldManager.getField(formattedFieldName);
            }
            return new FieldUnSupported(formattedFieldName);
        }
        for (Field field : fields) {
            if (field.getLongFormattedName().equalsIgnoreCase(formattedFieldName)) {
                return field;
            }
            if (!field.getShortFormattedName().equalsIgnoreCase(formattedFieldName)) continue;
            return field;
        }
        return new FieldUnSupported(formattedFieldName);
    }

    public Vector<Field> getFields(String type) {
        if ((type = type.trim()) == "@") {
            type = "database";
        } else if (type == "?") {
            type = "parameter";
        } else if (type == "!") {
            type = "formula";
        } else if (type == "%") {
            type = "system";
        }
        Vector<Field> fields = this.mapField.get(type);
        if (fields == null && this.parentFieldManager != null) {
            fields = this.parentFieldManager.getFields(type);
        }
        return fields;
    }

    public Vector<Field> getAllFields() {
        Vector<Field> fields = new Vector<Field>();
        for (Vector<Field> v : this.mapField.values()) {
            fields.addAll(v);
        }
        if (this.parentFieldManager != null) {
            fields.addAll(this.parentFieldManager.getAllFields());
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    public String replaceFieldValue(Context ctx, String text) {
        Object field;
        void var4_5;
        ArrayList<Object> listField = new ArrayList<Object>();
        boolean bl = false;
        while (var4_5 < text.length()) {
            char c = text.charAt((int)var4_5);
            if (c == '{') {
                field = "";
                void j = var4_5 + true;
                while (j < text.length()) {
                    c = text.charAt((int)j);
                    if (c == '}') {
                        listField.add(field);
                        var4_5 = j;
                        break;
                    }
                    field = String.valueOf(field) + c;
                    ++j;
                }
            }
            ++var4_5;
        }
        for (String string : listField) {
            field = this.getField(string);
            if (field == null || field instanceof FieldUnSupported) continue;
            text = text.replaceAll("\\{" + string + "\\}", ((Field)field).getValue(ctx));
        }
        return text;
    }
}

