/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.connection;

import java.util.ArrayList;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.FactoryConnection;
import net.hero.engine.data.dataset.DataSet;

public class ConnectionManager {
    protected ArrayList<Connection> listConnection = new ArrayList();

    public Connection getConnection(int index) {
        return this.listConnection.get(index);
    }

    public void addConnection(Connection connection) {
        this.listConnection.add(connection);
    }

    public int getConnectionCount() {
        return this.listConnection.size();
    }

    public Connection getConnection(String connectionName) {
        for (Connection connection : this.listConnection) {
            if (!connection.getName().equalsIgnoreCase(connectionName)) continue;
            return connection;
        }
        return null;
    }

    public DataSet getDataSet(String datasetName) {
        for (Connection connection : this.listConnection) {
            DataSet dataset = connection.getDataSet(datasetName);
            if (dataset == null) continue;
            return dataset;
        }
        return null;
    }

    public Connection createConnection(String connectionType, String connectionName) {
        Connection connection = FactoryConnection.getInstance().createConnection(connectionType);
        if (connection != null) {
            connection.setName(connectionName);
            this.addConnection(connection);
        }
        return connection;
    }
}

