/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.common.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import net.hero.engine.common.xml.XMLElementList;
import net.hero.engine.common.xml.XMLUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLElement {
    private Node nodeElement;

    public XMLElement() {
        this.nodeElement = null;
    }

    public XMLElement(Node node) {
        this.nodeElement = node;
    }

    public boolean isNull() {
        return this.nodeElement == null;
    }

    public XMLElementList selectNodes(String xpathString) {
        NodeList nodeList = null;
        if (!this.isNull()) {
            nodeList = (NodeList)XMLUtils.evaluateXPath(xpathString, this.nodeElement, XPathConstants.NODESET);
        }
        return new XMLElementList(nodeList);
    }

    public XMLElement selectSingleNode(String xpathString) {
        Node node = null;
        if (!this.isNull()) {
            node = (Node)XMLUtils.evaluateXPath(xpathString, this.nodeElement, XPathConstants.NODE);
        }
        return new XMLElement(node);
    }

    public String selectSingleNodeText(String xpathString) {
        String nodeText = "";
        if (!this.isNull()) {
            nodeText = (String)XMLUtils.evaluateXPath(xpathString, this.nodeElement, XPathConstants.STRING);
        }
        return nodeText;
    }

    public String getAttribute(String name) {
        if (this.isNull()) {
            return "";
        }
        NamedNodeMap namedNodeMap = this.nodeElement.getAttributes();
        if (namedNodeMap == null) {
            return "";
        }
        Node attributeNode = namedNodeMap.getNamedItem(name);
        if (attributeNode == null) {
            return "";
        }
        return attributeNode.getNodeValue();
    }

    public int getAttributeInt(String name) {
        String attribute = this.getAttribute(name);
        if (attribute.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(attribute);
    }

    public Map<String, String> getAllAttribute() {
        return this.getAllAttributePattern("");
    }

    public Map<String, String> getAllAttributePattern(String attributePattern) {
        Pattern p = null;
        if (!attributePattern.isEmpty()) {
            p = Pattern.compile(attributePattern);
        }
        HashMap<String, String> mapAttribute = new HashMap<String, String>();
        if (this.isNull()) {
            return mapAttribute;
        }
        NamedNodeMap namedNodeMap = this.nodeElement.getAttributes();
        if (namedNodeMap == null) {
            return mapAttribute;
        }
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attributeNode = namedNodeMap.item(i);
            if (attributeNode != null) {
                String name = attributeNode.getNodeName();
                String value = attributeNode.getNodeValue();
                if (p != null) {
                    Matcher m = p.matcher(name);
                    if (m.matches()) {
                        mapAttribute.put(name, value);
                    }
                } else {
                    mapAttribute.put(name, value);
                }
            }
            ++i;
        }
        return mapAttribute;
    }

    public int getChildCount() {
        if (this.isNull()) {
            return 0;
        }
        if (this.nodeElement.getChildNodes() != null) {
            return this.nodeElement.getChildNodes().getLength();
        }
        return 0;
    }

    public XMLElement getChild(int i) {
        if (this.isNull()) {
            return null;
        }
        if (this.nodeElement.getChildNodes() != null) {
            return new XMLElement(this.nodeElement.getChildNodes().item(i));
        }
        return null;
    }

    public String getText() {
        if (this.isNull()) {
            return "";
        }
        return this.nodeElement.getTextContent();
    }
}

