<%@ page import="java.sql.*,java.util.*" %>

<%!
// ȯ 迭
//  oracle, cubrid, mysql
String datatype[][] = {
	{"VARCHAR2","VARCHAR","varchar"},
	{"CHAR","CHAR","char"}, 
	{"NUMBER","NUMERIC","bigint"},
	{"LONG","CHARACTER VARYING","varying"},
	{"CLOB","GLO","longtext"},
	{"RAW","GLO","varbinary"},
	{"BLOB","GLO","longblob"},
	{"BFILE","GLO","longblob"},
	{"DATE", "DATE", "date"},
	{"DATE", "TIME", "time"},
	{"NUMBER", "INT", "int"},
	{"NUMBER", "SMALLINT", "bit"},
	{"NUMBER", "SMALLINT", "smallint"},
	{"NUMBER", "SMALLINT", "tinyint"},
	{"NUMBER", "INT", "mediumint"},
	{"NUMBER", "FLOAT", "float"},
	{"NUMBER", "DOUBLE PRECISION", "double"},
	{"NUMBER", "DOUBLE PRECISION", "double precision"},
	{"NUMBER", "DECIMAL", "decimal"},
	{"NUMBER", "DECIMAL", "dec"},
	{"TIMESTAMP", "TIMESTAMP", "timestamp"},
	{"TIMESTAMP", "TIMESTAMP", "datetime"},
	{"VARCHAR2", "VARCHAR", "year"},
	{"BLOB", "GLO", "binary"},
	{"BLOB", "GLO", "varbinary"},
	{"VARCHAR2", "VARCHAR", "text"},
	{"BLOB", "GLO", "blob"},
	{"BLOB", "GLO", "mediumblob"},
	{"BLOB", "GLO", "longblob"},
	{"VARCHAR2", "STRING", "longtext"},
	{"VARCHAR2", "STRING", "mediumtext"},
	{"VARCHAR2", "VARCHAR", "enum"},
	{"VARCHAR2", "SET VARCHAR", "set"},
	{"NUMBER", "INTEGER", "int"},
};

String makeExtra(String currentDB, String targetDB, ResultSet extra, String table_name)
{
	String exStr = "";
	try{

	if(currentDB.equals("O")){
		if(targetDB.equals("M"))
			;
		else{
			if(extra!=null){
				while(extra.next()){
					exStr = "create serial " + extra.getString("SEQUENCE_NAME") + " \n\t" +
						"START WITH " + extra.getString("LAST_NUMBER") + " \n\t" +
					        "INCREMENT BY " + extra.getString("INCREMENT_BY") + " \n\t" +
						"MINVALUE " + extra.getString("MIN_VALUE") + " \n\t";
					if(extra.getDouble("MAX_VALUE")<1.0E27)
						exStr = exStr + "MAXVALUE " + extra.getString("MAX_VALUE") + " \n\t";
					if(extra.getString("CYCLE_FLAG").equals("Y"))
						exStr = exStr + "CYCLE \n;";
					else
						exStr = exStr + "NOCYCLE \n;";
				}
			}
		}
	}
	else if(currentDB.equals("M")){
		if(targetDB.equals("O"))
			if(extra!=null){
				while(extra.next()){
					if(extra.getString("Extra").equals("auto_increment"))
						exStr = "create sequence " + table_name + "_" + extra.getString("Field") + "_seq \n\t" +
							"START WITH 1 \n\t" +
					        	"INCREMENT BY 1 \n\t" + 
							"NOCYCLE \n;\n\n";
				}
			}
		else
			if(extra!=null){
				while(extra.next()){
					if(extra.getString("Extra").equals("auto_increment"))
						exStr = "create serial " + table_name + "_" + extra.getString("Field") + "_seq \n\t" +
							"START WITH 1 \n\t" +
					        	"INCREMENT BY 1 \n\t" + 
							"NOCYCLE \n;\n\n";
				}
			}
	}
	else if(currentDB.equals("C")){
		if(targetDB.equals("O"))
			if(extra!=null){
				while(extra.next()){
					exStr = "create sequence " + extra.getString("name") + " \n\t" +
						"START WITH " + extra.getString("started") + " \n\t" +
					        "INCREMENT BY " + extra.getString("increment_val") + " \n\t" +
						"MINVALUE " + extra.getString("min_val") + " \n\t";
					if(extra.getDouble("max_val")<1.0E27)
						exStr = exStr + "MAXVALUE " + extra.getString("max_val") + " \n\t";
					if(extra.getString("cyclic").equals("1"))
						exStr = exStr + "CYCLE \n;";
					else
						exStr = exStr + "NOCYCLE \n;";
				}
			}
		else
			;
	}
	}catch(SQLException ex){
		writeLog("function","makeExtra", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","makeExtra", ex.getMessage());
	}

	return exStr ;
}

String makeQuery(String currentDB, String targetDB, ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{
	String query = "";
	
	if(currentDB.equals("O")){
		if(targetDB.equals("M"))
			query = _O2M(rs, pk, fk, index);
		else
			query = _O2C(rs, pk, fk, index);
	}
	else if(currentDB.equals("M")){
		if(targetDB.equals("O"))
			query = _M2O(rs, pk, fk, index);
		else
			query = _M2C(rs, pk, fk, index);
	}
	else if(currentDB.equals("C")){
		if(targetDB.equals("O"))
			query = _C2O(rs, pk, fk, index);
		else
			query = _C2M(rs, pk, fk, index);
	}
	return query;
}

String _O2C(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{
	String query = "";	
	
	try{	

	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("O", "C", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if(!TYPE_NAME.equals("DATE"))
				query = query + "(" + COLUMN_SIZE + ")";

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			if(COLUMN_DEF == null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("BLOB") || TYPE_NAME.equals("TEXT"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else
				query = query + " default " + COLUMN_DEF;

			query = query + ",\n\t";
			
		} // end while

		String PK_NAME = null;
		String PK_COLUMN_NAME = null;
		if(pk!=null){
			while(pk.next()){
				PK_NAME = pk.getString("PK_NAME");
				PK_COLUMN_NAME = pk.getString("COLUMN_NAME");
				query = query + "primary key(" + PK_COLUMN_NAME + "),\n\t";			
			}
		}
		
		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( ( index.getString("INDEX_NAME") != null ) && 
				    ( !index.getString("INDEX_NAME").equals(PK_NAME) ) &&
				    ( !index.getString("COLUMN_NAME").equals(PK_COLUMN_NAME) ) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}			
	} // end if

		
	}catch(SQLException ex){
		writeLog("function","_O2C", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_O2C", ex.getMessage());
	}
	return query;
}


String _M2O(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{
	String query = "";	
	String PK_TABLE_NAME = "";
	String PK_COLUMN_NAME = "";
	String pk_query = "";
	try{	

	if(pk!=null){
		while(pk.next()){
			PK_TABLE_NAME = pk.getString("TABLE_NAME");			
			PK_COLUMN_NAME = pk.getString("COLUMN_NAME");			
			pk_query = "constraint " + PK_TABLE_NAME + "_" + PK_COLUMN_NAME + "_pk " +
					          "primary key(" + PK_COLUMN_NAME + "),\n\t";		
		}
	}


	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("M", "O", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if( !TYPE_NAME.equals("DATE") && !TYPE_NAME.equals("TIMESTAMP") )
				query = query + "(" + COLUMN_SIZE + ")";

			if(COLUMN_DEF==null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("BLOB") || TYPE_NAME.equals("TEXT"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else if(!COLUMN_NAME.equals(PK_COLUMN_NAME))
				query = query + " default " + COLUMN_DEF;

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			query = query + ",\n\t";
			
		} // end while

		query = query + pk_query;		

		if(fk!=null){
			while(fk.next()){
				query = query + "constraint " + fk.getString("FKTABLE_NAME") + "_" + fk.getString("FKCOLUMN_NAME") + "_fk " +
					"foreign key (" + fk.getString("FKCOLUMN_NAME") 
					+ ") references " + fk.getString("PKTABLE_NAME") + "(" 
					+ fk.getString("PKCOLUMN_NAME") + "),\n\t";
			}
		}

		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( (index.getString("INDEX_NAME") != null) && 
				    ( !index.getString("TABLE_NAME").equals(PK_TABLE_NAME)) &&
				    ( !index.getString("COLUMN_NAME").equals(PK_COLUMN_NAME)) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}		
	} // end if

	}catch(SQLException ex){
		writeLog("function","_M2O", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_M2O", ex.getMessage());
	}	
	return query;
}



String _M2C(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{
	String query = "";	
	String PK_TABLE_NAME = "";
	String PK_COLUMN_NAME = "";
	String pk_query = "";
	try{	

	if(pk!=null){
		while(pk.next()){
			PK_TABLE_NAME = pk.getString("TABLE_NAME");			
			PK_COLUMN_NAME = pk.getString("COLUMN_NAME");			
			pk_query = "constraint " + PK_TABLE_NAME + "_" + PK_COLUMN_NAME + "_pk " +
					          "primary key(" + PK_COLUMN_NAME + "),\n\t";		
		}
	}

	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("M", "C", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if( TYPE_NAME.equals("DECIMAL") || 
			    TYPE_NAME.equals("VARCHAR") || 
			    TYPE_NAME.equals("CHAR") ||
         		    TYPE_NAME.equals("SET VARCHAR") )
				query = query + "(" + COLUMN_SIZE + ")";

			if(COLUMN_DEF==null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("BLOB") || TYPE_NAME.equals("TEXT"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else if(!COLUMN_NAME.equals(PK_COLUMN_NAME))
				query = query + " default " + COLUMN_DEF;

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			query = query + ",\n\t";
			
		} // end while

		query = query + pk_query;		

		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( (index.getString("INDEX_NAME") != null) && 
				    ( !index.getString("TABLE_NAME").equals(PK_TABLE_NAME)) &&
				    ( !index.getString("COLUMN_NAME").equals(PK_COLUMN_NAME)) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}			
	} // end if

	}catch(SQLException ex){
		writeLog("function","_M2C", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_M2C", ex.getMessage());
	}	
	return query;
}



String _C2O(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{

	String query = "";	
	
	try{	

	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("C", "O", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if(!TYPE_NAME.equals("DATE"))
				query = query + "(" + COLUMN_SIZE + ")";

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			if(COLUMN_DEF == null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("BLOB") || TYPE_NAME.equals("TEXT"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else
				query = query + " default " + COLUMN_DEF;

			query = query + ",\n\t";
			
		} // end while

		String PK_NAME = null;
		if(pk!=null){
			while(pk.next()){
				PK_NAME = pk.getString("PK_NAME");
				query = query + "primary key(" + pk.getString("COLUMN_NAME") + "),\n\t";			
			}
		}
		

		if(fk!=null){
			while(fk.next()){
				query = query + "constraint foreign key(" + fk.getString("FKCOLUMN_NAME") 
					+ ") references " + fk.getString("PKTABLE_NAME") + "(" 
					+ fk.getString("PKCOLUMN_NAME") + "),\n\t";
			}
		}

		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( (index.getString("INDEX_NAME") != null) && 
				    ( !index.getString("INDEX_NAME").equals(PK_NAME)) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}		
	} // end if

		
	}catch(SQLException ex){
		writeLog("function","_C2O", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_C2O", ex.getMessage());
	}	
	return query;
}



String _C2M(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{

	String query = "";	
	
	try{	

	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("C", "M", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if(!TYPE_NAME.equals("DATE"))
				query = query + "(" + COLUMN_SIZE + ")";

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			if(COLUMN_DEF == null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("BLOB") || TYPE_NAME.equals("TEXT"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else
				query = query + " default " + COLUMN_DEF;

			query = query + ",\n\t";
			
		} // end while

		String PK_NAME = null;
		if(pk!=null){
			while(pk.next()){
				PK_NAME = pk.getString("PK_NAME");
				query = query + "primary key(" + pk.getString("COLUMN_NAME") + "),\n\t";			
			}
		}
		

		if(fk!=null){
			while(fk.next()){
				query = query + "constraint foreign key(" + fk.getString("FKCOLUMN_NAME") 
					+ ") references " + fk.getString("PKTABLE_NAME") + "(" 
					+ fk.getString("PKCOLUMN_NAME") + "),\n\t";
			}
		}

		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( (index.getString("INDEX_NAME") != null) && 
				    ( !index.getString("INDEX_NAME").equals(PK_NAME)) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}		
	} // end if

		
	}catch(SQLException ex){
		writeLog("function","_C2M", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_C2M", ex.getMessage());
	}	
	return query;
}



String _O2M(ResultSet rs, ResultSet pk, ResultSet fk, ResultSet index)
{

	String query = "";	
	
	try{	

	if(rs!=null){
		while(rs.next()){
			if(rs.isFirst())
				query = "create table " + rs.getString("TABLE_NAME") + "(\n\t" ;

			String COLUMN_NAME = rs.getString("COLUMN_NAME");
			String TYPE_NAME   = TypeTrans("O", "M", rs.getString("TYPE_NAME"));
			String COLUMN_SIZE = rs.getString("COLUMN_SIZE");
			String NULLABLE    = rs.getString("NULLABLE");
			String COLUMN_DEF  = rs.getString("COLUMN_DEF");

			query = query + COLUMN_NAME + " " + TYPE_NAME;

			if(!TYPE_NAME.equals("date"))
				query = query + "(" + COLUMN_SIZE + ")";

			if(NULLABLE.equals("0"))
				query = query + " NOT NULL";

			if(COLUMN_DEF == null);
			else if(COLUMN_DEF.equals("0")){
				if(TYPE_NAME.equals("blob") || TYPE_NAME.equals("text"))
					query = query + " default \'0\'";
				else
					query = query + " default 0";
			}
			else
				query = query + " default " + COLUMN_DEF;

			query = query + ",\n\t";
			
		} // end while

		String PK_NAME = null;
		if(pk!=null){
			while(pk.next()){
				PK_NAME = pk.getString("PK_NAME");
				query = query + "primary key(" + pk.getString("COLUMN_NAME") + "),\n\t";			
			}
		}
		

		if(fk!=null){
			while(fk.next()){
				query = query + "constraint foreign key(" + fk.getString("FKCOLUMN_NAME") 
					+ ") references " + fk.getString("PKTABLE_NAME") + "(" 
					+ fk.getString("PKCOLUMN_NAME") + "),\n\t";
			}
		}

		query = query.substring(0, query.length()-3) + "\n);\n\n";
		
		if(index!=null){
			while(index.next())
				if( (index.getString("INDEX_NAME") != null) && 
				    ( !index.getString("INDEX_NAME").equals(PK_NAME)) )
					query = query + "create index " + index.getString("TABLE_NAME") + "_" + 
									  index.getString("COLUMN_NAME") + "_idx on " + 
									  index.getString("TABLE_NAME") + "(" + 
									  index.getString("COLUMN_NAME") + ");\n\n";
		}		
	} // end if

		
	}catch(SQLException ex){
		writeLog("function","_O2M", ex.getMessage());
	}catch(Exception ex){
		writeLog("function","_O2M", ex.getMessage());
	}	
	return query;
}

/* 
	datatype ȯ
   	 : TypeTrans(DB, DB, datatype)
*/
String TypeTrans(String db_type1, String db_type2, String data_type)
{
	if(db_type1.equals("O")){
		if(db_type2.equals("C")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][0])){
					data_type = datatype[i][1];
					break;
				} // end if	
			} // end for
		} // end if
		else if(db_type2.equals("M")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][0])){
					data_type = datatype[i][2];
					break;
				} // end if	
			} // end for
		} // end if
	} // end if 

	else if(db_type1.equals("M")){
		if(db_type2.equals("O")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][2])){
					data_type = datatype[i][0];
					break;
				}	
			}
		}
		else if(db_type2.equals("C")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][2])){
					data_type = datatype[i][1];
					break;
				}	
			}
		}
	}

	else if(db_type1.equals("C")){
		if(db_type2.equals("O")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][1])){
					data_type = datatype[i][0];
					break;
				}	
			}
		}
		else if(db_type2.equals("M")){
			for(int i=0; i<datatype.length; i++){
				if(data_type.equals(datatype[i][1])){
					data_type = datatype[i][2];
					break;
				}	
			}
		}
	}
	return data_type;	
}
%>
