/*
 * Decompiled with CFR 0.152.
 */
package unisql.sql;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDResultSet;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import unisql.jdbc.driver.UniSQLBlob;
import unisql.jdbc.driver.UniSQLClob;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLException;
import unisql.jdbc.driver.UniSQLJDBCErrorCode;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UJCIUtil;
import unisql.jdbc.jci.UStatement;

public class UniSQLOID
extends CUBRIDOID {
    public static final int GLO_MAX_SEND_SIZE = 16000;
    protected static final int GLO_MAX_SEARCH_LEN = 4096;
    private UniSQLConnection cur_con;
    private byte[] oid;
    private boolean is_closed;
    private UError error;

    public UniSQLOID(UniSQLConnection uniSQLConnection, byte[] byArray) {
        this.cur_con = uniSQLConnection;
        this.oid = byArray;
        this.is_closed = false;
    }

    public UniSQLOID(UniSQLOID uniSQLOID) {
        this.cur_con = uniSQLOID.cur_con;
        this.oid = uniSQLOID.oid;
        this.is_closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getValues(String[] stringArray) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UStatement uStatement = null;
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uStatement = uConnection.getByOID(this, stringArray);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        return new CUBRIDResultSet(uStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValues(String[] stringArray, Object[] objectArray) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (stringArray == null || objectArray == null) {
            throw new IllegalArgumentException();
        }
        if (stringArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.putByOID(this, stringArray, objectArray);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)1);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInstance() throws SQLException {
        Object object;
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            object = uConnection.oidCmd(this, (byte)2);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReadLock() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)3);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setWriteLock() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)4);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    public synchronized void loadGLO(OutputStream outputStream) throws SQLException {
        this.checkIsOpen();
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        UniSQLBlob uniSQLBlob = this.toBlob();
        InputStream inputStream = uniSQLBlob.getBinaryStream();
        this.stream_copy(inputStream, Integer.MAX_VALUE, outputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new UniSQLException(UniSQLJDBCErrorCode.unknown, iOException.getMessage());
        }
    }

    public synchronized void saveGLO(InputStream inputStream) throws SQLException {
        this.saveGLO(inputStream, Integer.MAX_VALUE);
    }

    public synchronized void saveGLO(InputStream inputStream, int n) throws SQLException {
        this.checkIsOpen();
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        UniSQLBlob uniSQLBlob = this.toBlob();
        uniSQLBlob.truncate(0L);
        OutputStream outputStream = uniSQLBlob.setBinaryStream(1L);
        this.stream_copy(inputStream, n, outputStream);
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new UniSQLException(UniSQLJDBCErrorCode.unknown, iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSet(String string, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.addElementToSet(this, string, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSet(String string, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.dropElementInSet(this, string, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSequence(String string, int n, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.insertElementIntoSequence(this, string, n, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putIntoSequence(String string, int n, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.putElementInSequence(this, string, n, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSequence(String string, int n) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.dropElementInSequence(this, string, n);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    public synchronized String getOidString() throws SQLException {
        this.checkIsOpen();
        if (this.oid == null || this.oid.length != 8) {
            return "";
        }
        return "@" + UJCIUtil.bytes2int(this.oid, 0) + "|" + UJCIUtil.bytes2short(this.oid, 4) + "|" + UJCIUtil.bytes2short(this.oid, 6);
    }

    public byte[] getOID() {
        return this.oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTableName() throws SQLException {
        String string;
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            string = (String)uConnection.oidCmd(this, (byte)5);
        }
        return string;
    }

    public static UniSQLOID getNewInstance(UniSQLConnection uniSQLConnection, String string) throws SQLException {
        if (uniSQLConnection == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (string.charAt(0) != '@') {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken().substring(1));
            short s = Short.parseShort(stringTokenizer.nextToken());
            short s2 = Short.parseShort(stringTokenizer.nextToken());
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF), (byte)(s >>> 8 & 0xFF), (byte)(s >>> 0 & 0xFF), (byte)(s2 >>> 8 & 0xFF), (byte)(s2 >>> 0 & 0xFF)};
            return new UniSQLOID(uniSQLConnection, byArray);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized UniSQLBlob toBlob() throws SQLException {
        return new CUBRIDBlob(this);
    }

    public synchronized UniSQLClob toClob() throws SQLException {
        return new CUBRIDClob(this, this.cur_con.getUConnection().getCharset());
    }

    public synchronized int gloRead(long l, int n, byte[] byArray, int n2) throws SQLException {
        this.checkIsOpen();
        --l;
        int n3 = 0;
        while (n > 0) {
            int n4 = Math.min(n, 16000);
            int n5 = this.gloCmd((byte)1, l, n4, byArray, n2);
            l += (long)n5;
            n -= n5;
            n2 += n5;
            n3 = n5;
            if (n5 >= n4) continue;
            break;
        }
        return n3;
    }

    public synchronized int gloWrite(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkIsOpen();
        --l;
        while (n2 > 0) {
            int n3 = Math.min(n2, 16000);
            this.gloCmd((byte)2, l, n3, byArray, n);
            l += (long)n3;
            n2 -= n3;
            n += n3;
        }
        return n2;
    }

    public synchronized void gloInsert(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkIsOpen();
        --l;
        while (n2 > 0) {
            int n3 = Math.min(n2, 16000);
            this.gloCmd((byte)3, l, n3, byArray, n);
            l += (long)n3;
            n2 -= n3;
            n += n3;
        }
    }

    public synchronized void gloDelete(long l, int n) throws SQLException {
        this.checkIsOpen();
        this.gloCmd((byte)4, l - 1L, n, null, 0);
    }

    protected synchronized void gloTruncate(long l) throws SQLException {
        this.checkIsOpen();
        this.gloCmd((byte)5, l, 0, null, 0);
    }

    public synchronized long gloSize() throws SQLException {
        this.checkIsOpen();
        return this.gloCmd((byte)7, 0L, 0, null, 0);
    }

    public synchronized long gloBinarySearch(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkIsOpen();
        n2 = Math.min(4096, n2);
        int n3 = this.gloCmd((byte)12, l - 1L, n2, byArray, n);
        return (long)n3 + 1L;
    }

    private void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.is_closed = true;
        this.cur_con = null;
        this.oid = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new UniSQLException(UniSQLJDBCErrorCode.oid_closed);
        }
    }

    private void checkError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case 17: {
                this.close();
                throw new UniSQLException(UniSQLJDBCErrorCode.oid_closed);
            }
            case 16: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new UniSQLException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int gloCmd(byte by, long l, int n, byte[] byArray, int n2) throws SQLException {
        int n3;
        UConnection uConnection;
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            n3 = uConnection.gloCmd(this, by, (int)l, n, byArray, n2);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        return n3;
    }

    private void stream_copy(InputStream inputStream, int n, OutputStream outputStream) throws SQLException {
        byte[] byArray = new byte[16000];
        try {
            while (n > 0) {
                int n2 = Math.min(n, 16000);
                if ((n2 = inputStream.read(byArray, 0, n2)) > 0) {
                    outputStream.write(byArray, 0, n2);
                    n -= n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new UniSQLException(UniSQLJDBCErrorCode.unknown, iOException.getMessage());
        }
    }
}

