/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import unisql.jdbc.jci.UJciException;
import unisql.jdbc.jci.UUType;
import unisql.sql.UniSQLOID;

class UniSQLArray {
    private byte baseType;
    private int length;
    private Object[] internalArray;

    UniSQLArray(byte by, int n) {
        this.baseType = by;
        this.length = n;
        if (this.length < 0) {
            return;
        }
        switch (by) {
            case 5: 
            case 6: {
                this.internalArray = (Object[])new byte[this.length][];
                break;
            }
            case 9: {
                this.internalArray = new Short[this.length];
                break;
            }
            case 8: {
                this.internalArray = new Integer[this.length];
                break;
            }
            case 11: {
                this.internalArray = new Float[this.length];
                break;
            }
            case 10: 
            case 12: {
                this.internalArray = new Double[this.length];
                break;
            }
            case 7: {
                this.internalArray = new BigDecimal[this.length];
                break;
            }
            case 13: {
                this.internalArray = new Date[this.length];
                break;
            }
            case 14: {
                this.internalArray = new Time[this.length];
                break;
            }
            case 15: {
                this.internalArray = new Timestamp[this.length];
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.internalArray = new String[this.length];
                break;
            }
            case 19: {
                this.internalArray = new UniSQLOID[this.length];
                break;
            }
            default: {
                this.baseType = 0;
                this.internalArray = new Object[this.length];
            }
        }
    }

    UniSQLArray(Object object) throws UJciException {
        this.baseType = object instanceof Object[] && ((Object[])object).length == 0 ? (byte)19 : UUType.getObjArrBaseDBtype(object);
        if (this.baseType == 0) {
            throw new UJciException(16);
        }
        this.internalArray = (Object[])((Object[])object).clone();
        this.length = ((Object[])object).length;
    }

    Object getArray() {
        return this.internalArray;
    }

    Object getArrayClone() {
        Object[] objectArray;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (this.internalArray == null) {
                            return null;
                        }
                        objectArray = (Object[])this.internalArray.clone();
                        if (!(objectArray instanceof Date[])) break block5;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null) continue;
                            objectArray[i] = ((Date)objectArray[i]).clone();
                        }
                        break block6;
                    }
                    if (!(objectArray instanceof Time[])) break block7;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null) continue;
                        objectArray[i] = ((Time)objectArray[i]).clone();
                    }
                    break block6;
                }
                if (!(objectArray instanceof Timestamp[])) break block8;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    objectArray[i] = ((Timestamp)objectArray[i]).clone();
                }
                break block6;
            }
            if (!(objectArray instanceof byte[][])) break block6;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                objectArray[i] = ((byte[])objectArray[i]).clone();
            }
        }
        return objectArray;
    }

    int getBaseType() {
        return this.baseType;
    }

    int getLength() {
        return this.length;
    }

    synchronized void setElement(int n, Object object) {
        this.internalArray[n] = object;
    }
}

