/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLXid;
import unisql.jdbc.jci.UJCIManager;
import unisql.jdbc.jci.UJCIUtil;
import unisql.jdbc.jci.UJciException;
import unisql.sql.UniSQLOID;

class UInputBuffer {
    private InputStream input;
    private int position;
    private int capacity;
    private byte[] buffer;
    private int resCode;

    UInputBuffer(InputStream inputStream) throws IOException, UJciException {
        this.input = inputStream;
        this.position = 0;
        byte[] byArray = new byte[4];
        this.input.read(byArray);
        this.capacity = UJCIUtil.bytes2int(byArray, 0);
        if (this.capacity < 0) {
            this.capacity = 0;
            return;
        }
        this.buffer = new byte[this.capacity];
        this.readData();
        this.resCode = this.readInt();
        if (this.resCode < 0) {
            String string = this.readString(this.remainedCapacity(), UJCIManager.sysCharsetName);
            throw new UJciException(2, this.resCode, string);
        }
    }

    int getResCode() {
        return this.resCode;
    }

    byte readByte() throws UJciException {
        if (this.position >= this.capacity) {
            throw new UJciException(19);
        }
        return this.buffer[this.position++];
    }

    void readBytes(byte[] byArray, int n, int n2) throws UJciException {
        if (byArray == null) {
            return;
        }
        if (this.position + n2 > this.capacity) {
            throw new UJciException(19);
        }
        System.arraycopy(this.buffer, this.position, byArray, n, n2);
        this.position += n2;
    }

    void readBytes(byte[] byArray) throws UJciException {
        this.readBytes(byArray, 0, byArray.length);
    }

    byte[] readBytes(int n) throws UJciException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    double readDouble() throws UJciException {
        return Double.longBitsToDouble(this.readLong());
    }

    float readFloat() throws UJciException {
        return Float.intBitsToFloat(this.readInt());
    }

    int readInt() throws UJciException {
        if (this.position + 4 > this.capacity) {
            throw new UJciException(19);
        }
        int n = UJCIUtil.bytes2int(this.buffer, this.position);
        this.position += 4;
        return n;
    }

    long readLong() throws UJciException {
        long l = 0L;
        if (this.position + 8 > this.capacity) {
            throw new UJciException(19);
        }
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(this.buffer[this.position++] & 0xFF);
        }
        return l;
    }

    short readShort() throws UJciException {
        if (this.position + 2 > this.capacity) {
            throw new UJciException(19);
        }
        short s = UJCIUtil.bytes2short(this.buffer, this.position);
        this.position += 2;
        return s;
    }

    String readString(int n, String string) throws UJciException {
        String string2;
        if (n <= 0) {
            return null;
        }
        if (this.position + n > this.capacity) {
            throw new UJciException(19);
        }
        try {
            string2 = new String(this.buffer, this.position, n - 1, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(this.buffer, this.position, n - 1);
        }
        this.position += n;
        return string2;
    }

    Date readDate() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        String string = "";
        string = s < 10 ? string + "000" + s + "-" : (s < 100 ? string + "00" + s + "-" : (s < 1000 ? string + "0" + s + "-" : string + s + "-"));
        string = s2 < 10 ? string + "0" + s2 + "-" : string + s2 + "-";
        string = s3 < 10 ? string + "0" + s3 : string + s3;
        return Date.valueOf(string);
    }

    Time readTime() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        String string = "";
        string = s < 10 ? string + "0" + s + ":" : string + s + ":";
        string = s2 < 10 ? string + "0" + s2 + ":" : string + s2 + ":";
        string = s3 < 10 ? string + "0" + s3 : string + s3;
        return Time.valueOf(string);
    }

    Timestamp readTimestamp() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        short s4 = this.readShort();
        short s5 = this.readShort();
        short s6 = this.readShort();
        String string = "";
        string = s < 10 ? string + "000" + s + "-" : (s < 100 ? string + "00" + s + "-" : (s < 1000 ? string + "0" + s + "-" : string + s + "-"));
        string = s2 < 10 ? string + "0" + s2 + "-" : string + s2 + "-";
        string = s3 < 10 ? string + "0" + s3 + " " : string + s3 + " ";
        string = s4 < 10 ? string + "0" + s4 + ":" : string + s4 + ":";
        string = s5 < 10 ? string + "0" + s5 + ":" : string + s5 + ":";
        string = s6 < 10 ? string + "0" + s6 : string + s6;
        return Timestamp.valueOf(string);
    }

    UniSQLOID readOID(UniSQLConnection uniSQLConnection) throws UJciException {
        byte[] byArray = this.readBytes(8);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return new UniSQLOID(uniSQLConnection, byArray);
        }
        return null;
    }

    int remainedCapacity() {
        return this.capacity - this.position;
    }

    UniSQLXid readXid() throws UJciException {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        byte[] byArray = this.readBytes(n3);
        byte[] byArray2 = this.readBytes(n4);
        return new UniSQLXid(n2, byArray, byArray2);
    }

    private void readData() throws IOException {
        int n = 0;
        for (int i = 0; i < this.capacity; i += n) {
            n = this.input.read(this.buffer, i, this.capacity - i);
            if (n >= 0) continue;
            this.capacity = i;
            break;
        }
    }
}

