/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import unisql.jdbc.jci.UErrorCode;

public class UError {
    public static final int JCI_ERROR_CODE_BASE = -2000;
    public static final int DRIVER_ERROR_CODE_BASE = -2100;
    public static final int METHOD_USER_ERROR_BASE = -10000;
    private int jciErrorCode;
    private int serverErrorCode;
    private String errorMessage;

    UError() {
        this.jciErrorCode = 0;
    }

    public UError(UError uError) {
        this.copyValue(uError);
    }

    public int getErrorCode() {
        return this.jciErrorCode;
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public int getJdbcErrorCode() {
        if (this.jciErrorCode == 0) {
            return 0;
        }
        if (this.jciErrorCode == 2) {
            return this.serverErrorCode;
        }
        return -2000 - this.jciErrorCode;
    }

    void copyValue(UError uError) {
        this.jciErrorCode = uError.jciErrorCode;
        this.errorMessage = uError.errorMessage;
        this.serverErrorCode = uError.serverErrorCode;
    }

    synchronized void setDBError(int n, String string) {
        this.jciErrorCode = 2;
        this.serverErrorCode = n;
        this.errorMessage = string;
    }

    synchronized void setErrorCode(int n) {
        this.jciErrorCode = n;
        if (n != 0) {
            this.errorMessage = UErrorCode.codeToMessage(n);
        }
    }

    void setErrorMessage(int n, String string) {
        this.setErrorCode(n);
        this.errorMessage = this.errorMessage + ":" + string;
    }

    void clear() {
        this.jciErrorCode = 0;
    }
}

