/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import unisql.jdbc.jci.UConnection;
import unisql.sql.UniSQLOID;

public class UColumnInfo {
    private static final byte GLO_INSTANCE_FALSE = 0;
    private static final byte GLO_INSTANCE_TRUE = 1;
    private static final byte GLO_INSTANCE_UNKNOWN = -1;
    private byte type;
    private byte collectionBaseType;
    private short scale;
    private int precision;
    private String name;
    private String className;
    private String attributeName;
    private boolean isNullable;
    private byte glo_instance_flag;

    UColumnInfo(byte by, short s, int n, String string) {
        byte[] byArray = UColumnInfo.confirmType(by);
        this.type = byArray[0];
        this.collectionBaseType = byArray[1];
        this.scale = s;
        this.precision = n;
        this.name = string;
        this.className = null;
        this.attributeName = null;
        this.isNullable = false;
        this.glo_instance_flag = (byte)-1;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCollectionBaseType() {
        return this.collectionBaseType;
    }

    public String getColumnName() {
        return this.name;
    }

    public int getColumnPrecision() {
        return this.precision;
    }

    public int getColumnScale() {
        return this.scale;
    }

    public byte getColumnType() {
        return this.type;
    }

    public String getFQDN() {
        return UColumnInfo.findFQDN(this.type, this.precision, this.collectionBaseType);
    }

    public String getRealColumnName() {
        return this.attributeName;
    }

    static byte[] confirmType(byte by) {
        int n = 0;
        byte[] byArray = new byte[2];
        n = by & 0x60;
        switch (n) {
            case 0: {
                byArray[0] = by;
                byArray[1] = -1;
                return byArray;
            }
            case 32: {
                byArray[0] = 16;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
            case 64: {
                byArray[0] = 17;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
            case 96: {
                byArray[0] = 18;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
        }
        byArray[0] = 0;
        byArray[1] = -1;
        return byArray;
    }

    synchronized void setRemainedData(String string, String string2, boolean bl) {
        this.attributeName = string;
        this.className = string2;
        this.isNullable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isGloInstance(UConnection uConnection, UniSQLOID uniSQLOID) {
        if (this.glo_instance_flag == -1) {
            Object object;
            UConnection uConnection2 = uConnection;
            synchronized (uConnection2) {
                object = uConnection.oidCmd(uniSQLOID, (byte)6);
            }
            this.glo_instance_flag = object == null ? (byte)0 : 1;
        }
        return this.glo_instance_flag == 1;
    }

    private static String findFQDN(byte by, int n, byte by2) {
        switch (by) {
            case 0: {
                return "null";
            }
            case 5: {
                return n == 8 ? "java.lang.Boolean" : "byte[]";
            }
            case 6: {
                return "byte[]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "java.lang.String";
            }
            case 7: {
                return "java.lang.Double";
            }
            case 9: {
                return "java.lang.Short";
            }
            case 8: {
                return "java.lang.Integer";
            }
            case 11: {
                return "java.lang.Float";
            }
            case 10: 
            case 12: {
                return "java.lang.Double";
            }
            case 13: {
                return "java.sql.Date";
            }
            case 14: {
                return "java.sql.Time";
            }
            case 15: {
                return "java.sql.Timestamp";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "unisql.sql.UniSQLOID";
            }
            default: {
                return "";
            }
        }
        switch (by2) {
            case 0: {
                return "null";
            }
            case 5: {
                return n == 8 ? "java.lang.Boolean[]" : "byte[][]";
            }
            case 6: {
                return "byte[][]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "java.lang.String[]";
            }
            case 7: {
                return "java.lang.Double[]";
            }
            case 9: {
                return "java.lang.Short[]";
            }
            case 8: {
                return "java.lang.Integer[]";
            }
            case 11: {
                return "java.lang.Float[]";
            }
            case 10: 
            case 12: {
                return "java.lang.Double[]";
            }
            case 13: {
                return "java.sql.Date[]";
            }
            case 14: {
                return "java.sql.Time[]";
            }
            case 15: {
                return "java.sql.Timestamp[]";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "unisql.sql.UniSQLOID[]";
            }
        }
        return null;
    }
}

