/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.PrintStream;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import unisql.jdbc.driver.UniSQLXAConnection;
import unisql.jdbc.driver.UniSQLXidInfo;
import unisql.jdbc.driver.UniSQLXidTable;
import unisql.jdbc.jci.UConnection;

public class UniSQLXAResource
implements XAResource {
    private UniSQLXAConnection xacon;
    private PrintStream debug_out;
    private String xacon_key;

    protected UniSQLXAResource(UniSQLXAConnection uniSQLXAConnection, String string) {
        this.xacon = uniSQLXAConnection;
        this.xacon_key = string;
        this.debug_out = null;
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource(" + string + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        UniSQLXidInfo uniSQLXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.commit(" + xid + "," + bl + ")");
        }
        if ((uniSQLXidInfo = UniSQLXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        UniSQLXidInfo uniSQLXidInfo2 = uniSQLXidInfo;
        synchronized (uniSQLXidInfo2) {
            if (bl ? uniSQLXidInfo.status != 0 : uniSQLXidInfo.status != 3 && uniSQLXidInfo.status != 4) {
                throw new XAException(-6);
            }
            this.end_tran(uniSQLXidInfo.ucon, xid, uniSQLXidInfo.status, true);
            uniSQLXidInfo.status = 5;
        }
        UniSQLXidTable.removeXid(this.xacon_key, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.end(" + xid + "," + n + ")");
        }
        if (n != 0x4000000 && n != 0x20000000 && n != 0x2000000) {
            throw new XAException(-5);
        }
        UniSQLXidInfo uniSQLXidInfo = UniSQLXidTable.getXid(this.xacon_key, xid);
        if (uniSQLXidInfo == null) {
            throw new XAException(-4);
        }
        UniSQLXidInfo uniSQLXidInfo2 = uniSQLXidInfo;
        synchronized (uniSQLXidInfo2) {
            if (uniSQLXidInfo.status != 1 && uniSQLXidInfo.status != 2 && uniSQLXidInfo.status != 0) {
                throw new XAException(-6);
            }
            if (!this.xacon.xa_end()) {
                throw new XAException(-3);
            }
            uniSQLXidInfo.status = n == 0x2000000 ? 2 : 0;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.forget()");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.getTransactionTimeout()");
        }
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.isSameRM()");
        }
        return xAResource instanceof UniSQLXAResource && this.xacon_key.compareTo(((UniSQLXAResource)xAResource).xacon_key) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        UniSQLXidInfo uniSQLXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.prepare()");
        }
        if ((uniSQLXidInfo = UniSQLXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        UniSQLXidInfo uniSQLXidInfo2 = uniSQLXidInfo;
        synchronized (uniSQLXidInfo2) {
            if (uniSQLXidInfo.status != 0) {
                throw new XAException(-6);
            }
            UConnection uConnection = uniSQLXidInfo.ucon;
            if (uConnection == null) {
                throw new XAException(-3);
            }
            UConnection uConnection2 = uConnection;
            synchronized (uConnection2) {
                uConnection.xa_prepare(xid);
                if (uConnection.getRecentError().getErrorCode() != 0) {
                    throw new XAException(-3);
                }
            }
            uniSQLXidInfo.status = 3;
        }
        return 0;
    }

    public Xid[] recover(int n) throws XAException {
        UConnection uConnection;
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.recover()");
        }
        try {
            uConnection = this.xacon.createUConnection();
        }
        catch (Exception exception) {
            throw new XAException(-3);
        }
        Xid[] xidArray = uConnection.xa_recover();
        if (uConnection.getRecentError().getErrorCode() != 0) {
            throw new XAException(-3);
        }
        for (int i = 0; i < xidArray.length; ++i) {
            UniSQLXidInfo uniSQLXidInfo = new UniSQLXidInfo(xidArray[i], null, 4);
            UniSQLXidTable.putXidInfo(this.xacon_key, uniSQLXidInfo);
        }
        uConnection.close();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        UniSQLXidInfo uniSQLXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.rollback()");
        }
        if ((uniSQLXidInfo = UniSQLXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        UniSQLXidInfo uniSQLXidInfo2 = uniSQLXidInfo;
        synchronized (uniSQLXidInfo2) {
            this.end_tran(uniSQLXidInfo.ucon, xid, uniSQLXidInfo.status, false);
            uniSQLXidInfo.status = 5;
        }
        UniSQLXidTable.removeXid(this.xacon_key, xid);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.setTransactionTimeout()");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("UniSQLXAResource.start(" + xid + "," + n + ")");
        }
        if (!this.checkXid(xid)) {
            throw new XAException(-5);
        }
        UniSQLXidInfo uniSQLXidInfo = UniSQLXidTable.getXid(this.xacon_key, xid);
        if (n == 0) {
            if (uniSQLXidInfo != null) {
                throw new XAException(-8);
            }
            UConnection uConnection = this.xacon.xa_start(n, null);
            if (uConnection == null) {
                throw new XAException(-3);
            }
            uniSQLXidInfo = new UniSQLXidInfo(xid, uConnection, 1);
            UniSQLXidTable.putXidInfo(this.xacon_key, uniSQLXidInfo);
        } else if (n == 0x200000 || n == 0x8000000) {
            if (uniSQLXidInfo == null) {
                throw new XAException(-4);
            }
            UniSQLXidInfo uniSQLXidInfo2 = uniSQLXidInfo;
            synchronized (uniSQLXidInfo2) {
                if (uniSQLXidInfo.status != 0 && uniSQLXidInfo.status != 2) {
                    throw new XAException(-6);
                }
                if (this.xacon.xa_start(n, uniSQLXidInfo.ucon) == null) {
                    throw new XAException(-3);
                }
                uniSQLXidInfo.status = 1;
            }
        } else {
            throw new XAException(-5);
        }
    }

    private boolean checkXid(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray == null || byArray.length == 0 || byArray.length > 64) {
            return false;
        }
        return byArray2 != null && byArray2.length != 0 && byArray2.length <= 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end_tran(UConnection uConnection, Xid xid, int n, boolean bl) throws XAException {
        if (uConnection == null) {
            try {
                uConnection = this.xacon.createUConnection();
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
        }
        UConnection uConnection2 = uConnection;
        synchronized (uConnection2) {
            if (n == 4) {
                uConnection.xa_endTransaction(xid, bl);
            } else {
                uConnection.endTransaction(bl);
            }
            if (uConnection.getRecentError().getErrorCode() != 0) {
                throw new XAException(-7);
            }
        }
        uConnection = this.xacon.xa_end_tran(uConnection);
        if (uConnection != null) {
            uConnection2 = uConnection;
            synchronized (uConnection2) {
                uConnection.close();
            }
        }
    }
}

