/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import unisql.jdbc.driver.UniSQLCancelQueryThread;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.jci.UBatchResult;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UResultInfo;
import unisql.jdbc.jci.UStatement;
import unisql.sql.UniSQLOID;

public class UniSQLStatement
implements Statement {
    protected UniSQLConnection con;
    protected UConnection u_con;
    protected UStatement u_stmt;
    protected UError error;
    protected boolean completed;
    protected UResultInfo[] result_info;
    protected CUBRIDResultSet current_result_set;
    protected boolean is_closed;
    protected int update_count;
    protected boolean query_info_flag;
    private int max_field_size;
    private int max_rows;
    private int query_timeout;
    private int type;
    private int concurrency;
    private boolean is_scrollable;
    private boolean is_updatable;
    private boolean is_sensitive;
    private int fetch_direction;
    private int fetch_size;
    private ArrayList batchs;
    private int result_index;

    protected UniSQLStatement(UniSQLConnection uniSQLConnection, int n, int n2) {
        this.con = uniSQLConnection;
        this.u_con = this.con.u_con;
        this.u_stmt = null;
        this.is_closed = false;
        this.max_field_size = 0;
        this.max_rows = 0;
        this.update_count = -1;
        this.current_result_set = null;
        this.query_timeout = 0;
        this.error = null;
        this.type = n;
        this.concurrency = n2;
        this.is_scrollable = n != 1003;
        this.is_updatable = n2 == 1008;
        this.is_sensitive = n == 1005;
        this.fetch_direction = 1000;
        this.fetch_size = 0;
        this.batchs = new ArrayList();
        this.completed = true;
        this.result_info = null;
        this.query_info_flag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    if (!this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeQuery);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    this.current_result_set.complete_on_close = true;
                    return this.current_result_set;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    if (this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeUpdate);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    this.complete();
                    return this.update_count;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    if (this.is_closed) {
                        return;
                    }
                    this.is_closed = true;
                    this.complete();
                    this.con = null;
                    this.u_con = null;
                    this.error = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkIsOpen();
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.max_field_size = n;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.checkIsOpen();
        return this.max_rows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.max_rows = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkIsOpen();
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.checkIsOpen();
        return this.query_timeout;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.query_timeout = n;
    }

    public void cancel() throws SQLException {
        try {
            UError uError = this.u_stmt.cancel();
            switch (uError.getErrorCode()) {
                case 0: 
                case 17: {
                    break;
                }
                default: {
                    throw new CUBRIDException(uError);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    public synchronized void setCursorName(String string) throws SQLException {
        this.checkIsOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    this.executeCore(true);
                    return this.getMoreResults();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkIsOpen();
        return this.current_result_set;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.checkIsOpen();
        return this.update_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    boolean bl;
                    this.checkIsOpen();
                    if (this.current_result_set != null) {
                        this.current_result_set.close();
                        this.current_result_set = null;
                    }
                    if (this.completed) {
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index == this.result_info.length) {
                        if (this.u_stmt.getCommandType() != 126) {
                            this.complete();
                        }
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index != 0) {
                        this.u_stmt.nextResult();
                        this.error = this.u_stmt.getRecentError();
                        switch (this.error.getErrorCode()) {
                            case 0: {
                                break;
                            }
                            default: {
                                throw new CUBRIDException(this.error);
                            }
                        }
                    }
                    if (bl = this.result_info[this.result_index].isResultSet()) {
                        int n = this.type;
                        int n2 = this.concurrency;
                        if (this.type == 1005 && !this.u_stmt.isOIDIncluded()) {
                            n = 1004;
                        }
                        if (this.concurrency == 1008 && !this.u_stmt.isOIDIncluded()) {
                            n2 = 1007;
                        }
                        this.current_result_set = new CUBRIDResultSet(this.con, this, n, n2);
                    } else {
                        this.update_count = this.result_info[this.result_index].getResultCount();
                    }
                    ++this.result_index;
                    return bl;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        this.checkIsOpen();
        if (!this.is_scrollable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable_statement);
        }
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetch_direction = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return this.fetch_direction;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.fetch_size = n;
    }

    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkIsOpen();
        return this.concurrency;
    }

    public synchronized int getResultSetType() throws SQLException {
        this.checkIsOpen();
        return this.type;
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.checkIsOpen();
        this.batchs.add(string);
    }

    public synchronized void clearBatch() throws SQLException {
        this.checkIsOpen();
        this.batchs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    String[] stringArray = new String[this.batchs.size()];
                    for (int i = 0; i < this.batchs.size(); ++i) {
                        stringArray[i] = (String)this.batchs.get(i);
                    }
                    UBatchResult uBatchResult = this.u_con.batchExecute(stringArray);
                    this.error = this.u_con.getRecentError();
                    switch (this.error.getErrorCode()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw new CUBRIDException(this.error);
                        }
                    }
                    this.con.autoCommit();
                    return this.checkBatchResult(uBatchResult);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkIsOpen();
        return this.con;
    }

    public synchronized boolean execute(String string, int n) throws SQLException {
        boolean bl = this.execute(string);
        return bl;
    }

    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl = this.execute(string);
        return bl;
    }

    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl = this.execute(string);
        return bl;
    }

    public synchronized int executeUpdate(String string, int n) throws SQLException {
        int n2 = this.executeUpdate(string);
        return n2;
    }

    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        int n = this.executeUpdate(string);
        return n;
    }

    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n = this.executeUpdate(string);
        return n;
    }

    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public synchronized boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    public synchronized int getResultSetHoldability() throws SQLException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniSQLOID executeInsert(String string) throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this;
                synchronized (uniSQLStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    UniSQLOID uniSQLOID = this.executeInsertCore();
                    this.complete();
                    return uniSQLOID;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    public byte getStatementType() {
        if (this.u_stmt != null) {
            return this.u_stmt.getCommandType();
        }
        return 127;
    }

    public String getQueryplan() throws SQLException {
        this.checkIsOpen();
        if (this.u_stmt == null) {
            return "";
        }
        String string = this.u_stmt.getQueryplan();
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setQueryInfo(boolean bl) {
        this.query_info_flag = bl;
    }

    protected UniSQLOID executeInsertCore() throws SQLException {
        UniSQLCancelQueryThread uniSQLCancelQueryThread = null;
        if (this.query_timeout > 0) {
            uniSQLCancelQueryThread = new UniSQLCancelQueryThread(this, this.query_timeout);
            uniSQLCancelQueryThread.start();
        }
        UniSQLOID uniSQLOID = this.u_stmt.executeInsert(false);
        if (this.query_timeout > 0) {
            uniSQLCancelQueryThread.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case 22: {
                this.con.autoRollback();
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeInsert);
            }
            default: {
                UError uError = new UError(this.error);
                this.con.autoRollback();
                throw new CUBRIDException(uError);
            }
        }
        this.completed = false;
        return uniSQLOID;
    }

    protected int[] checkBatchResult(UBatchResult uBatchResult) throws SQLException {
        int[] nArray = uBatchResult.getResult();
        if (!uBatchResult.getErrorFlag()) {
            return nArray;
        }
        int n = uBatchResult.getResultNumber();
        String[] stringArray = uBatchResult.getErrorMessage();
        int[] nArray2 = uBatchResult.getErrorCode();
        BatchUpdateException batchUpdateException = null;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 0) continue;
            if (batchUpdateException == null) {
                batchUpdateException = new BatchUpdateException(stringArray[i], null, nArray2[i], nArray);
                continue;
            }
            batchUpdateException.setNextException(new SQLException(stringArray[i], null, nArray2[i]));
        }
        throw batchUpdateException;
    }

    protected void executeCore(boolean bl) throws SQLException {
        UniSQLCancelQueryThread uniSQLCancelQueryThread = null;
        if (this.query_timeout > 0) {
            uniSQLCancelQueryThread = new UniSQLCancelQueryThread(this, this.query_timeout);
            uniSQLCancelQueryThread.start();
        }
        this.u_stmt.execute(false, this.max_rows, this.max_field_size, bl, this.is_sensitive, this.query_info_flag);
        if (this.query_timeout > 0) {
            uniSQLCancelQueryThread.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        this.checkExecuteError();
        this.result_info = this.u_stmt.getResultInfo();
        this.result_index = 0;
        this.completed = false;
    }

    void complete() throws SQLException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.current_result_set != null) {
            this.current_result_set.close();
            this.current_result_set = null;
        }
        if (this.u_stmt != null) {
            this.u_stmt.close();
            if (!this.u_stmt.isReturnable()) {
                this.u_stmt = null;
            }
        }
        this.result_info = null;
        this.con.autoCommit();
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    private void prepare(String string) throws SQLException {
        byte by = this.is_updatable || this.is_sensitive ? (byte)2 : 0;
        this.u_stmt = this.con.prepare(string, by);
    }

    private void checkExecuteError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                UError uError = new UError(this.error);
                this.con.autoRollback();
                throw new CUBRIDException(uError);
            }
        }
    }
}

