/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLInputStream;
import unisql.jdbc.driver.UniSQLReader;
import unisql.jdbc.driver.UniSQLResultSetMetaData;
import unisql.jdbc.driver.UniSQLStatement;
import unisql.jdbc.jci.UColumnInfo;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UStatement;
import unisql.sql.UniSQLOID;

public class UniSQLResultSet
implements ResultSet {
    public boolean complete_on_close;
    private UniSQLConnection con;
    private UniSQLStatement stmt;
    protected UStatement u_stmt;
    protected int number_of_rows;
    private int current_row;
    protected UColumnInfo[] column_info;
    protected boolean is_closed;
    private boolean was_null;
    private boolean close_u_stmt_on_close;
    protected UError error;
    private UniSQLResultSetMetaData meta_data;
    protected ArrayList streams;
    private int type;
    private int concurrency;
    private boolean is_scrollable;
    private boolean is_updatable;
    private boolean is_sensitive;
    private int fetch_direction;
    private int fetch_size;
    private boolean inserting;
    private boolean[] updatable;
    private boolean[] updated;
    private Object[] updates;
    private int number_of_updates;
    private String main_table_name;

    protected UniSQLResultSet(UniSQLConnection uniSQLConnection, UniSQLStatement uniSQLStatement, int n, int n2) throws SQLException {
        this.con = uniSQLConnection;
        this.stmt = uniSQLStatement;
        this.u_stmt = uniSQLStatement.u_stmt;
        this.number_of_rows = this.u_stmt.getExecuteResult();
        this.current_row = -1;
        this.column_info = this.u_stmt.getColumnInfo();
        this.is_closed = false;
        this.was_null = false;
        this.complete_on_close = false;
        this.close_u_stmt_on_close = false;
        this.meta_data = null;
        this.streams = new ArrayList();
        this.type = n;
        this.concurrency = n2;
        this.is_scrollable = n != 1003;
        this.is_updatable = n2 == 1008;
        this.is_sensitive = n == 1005;
        this.fetch_direction = uniSQLStatement.getFetchDirection();
        this.u_stmt.setFetchDirection(this.fetch_direction);
        this.fetch_size = uniSQLStatement.getFetchSize();
        this.u_stmt.setFetchSize(this.fetch_size);
        this.inserting = false;
        if (this.is_updatable) {
            this.updatable = new boolean[this.column_info.length];
            this.updated = new boolean[this.column_info.length];
            this.updates = new Object[this.column_info.length];
            this.main_table_name = null;
            for (int i = 0; i < this.column_info.length; ++i) {
                boolean bl = this.updatable[i] = this.column_info[i].getRealColumnName().length() > 0;
                if (!this.updatable[i]) continue;
                this.main_table_name = this.column_info[i].getClassName();
            }
            this.clearCurrentRow();
        }
    }

    public UniSQLResultSet(UStatement uStatement) {
        this.con = null;
        this.stmt = null;
        this.u_stmt = uStatement;
        this.number_of_rows = 1;
        this.current_row = -1;
        if (this.u_stmt != null) {
            this.column_info = this.u_stmt.getColumnInfo();
        }
        this.is_closed = false;
        this.was_null = false;
        this.complete_on_close = false;
        this.close_u_stmt_on_close = true;
        this.streams = new ArrayList();
        this.type = 1003;
        this.concurrency = 1007;
        this.is_scrollable = false;
        this.is_updatable = false;
        this.is_sensitive = false;
        this.fetch_direction = 1000;
        this.fetch_size = 0;
        this.inserting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this.stmt;
                synchronized (uniSQLStatement) {
                    UniSQLResultSet uniSQLResultSet = this;
                    synchronized (uniSQLResultSet) {
                        this.checkIsOpen();
                        this.clearCurrentRow();
                        ++this.current_row;
                        if (this.current_row >= this.number_of_rows) {
                            this.current_row = this.number_of_rows;
                            if (!this.is_scrollable) {
                                this.close();
                            }
                            return false;
                        }
                        this.move();
                        this.inserting = false;
                        return true;
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            UniSQLResultSet uniSQLResultSet = this;
            synchronized (uniSQLResultSet) {
                this.checkIsOpen();
                this.clearCurrentRow();
                ++this.current_row;
                if (this.current_row >= this.number_of_rows) {
                    this.current_row = this.number_of_rows;
                    if (!this.is_scrollable) {
                        this.close();
                    }
                    return false;
                }
                this.move();
                this.inserting = false;
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLStatement uniSQLStatement = this.stmt;
                synchronized (uniSQLStatement) {
                    UniSQLResultSet uniSQLResultSet = this;
                    synchronized (uniSQLResultSet) {
                        if (this.is_closed) {
                            return;
                        }
                        this.is_closed = true;
                        this.clearCurrentRow();
                        if (this.complete_on_close) {
                            this.stmt.complete();
                        }
                        if (this.close_u_stmt_on_close) {
                            this.u_stmt.close();
                        }
                        this.streams = null;
                        this.con = null;
                        this.stmt = null;
                        if (!this.u_stmt.isReturnable()) {
                            this.u_stmt = null;
                        }
                        this.column_info = null;
                        this.error = null;
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getString(int n) throws SQLException {
        String string;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            string = this.u_stmt.getString(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            bl = this.u_stmt.getBoolean(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte getByte(int n) throws SQLException {
        byte by;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            by = this.u_stmt.getByte(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized short getShort(int n) throws SQLException {
        short s;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            s = this.u_stmt.getShort(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getInt(int n) throws SQLException {
        int n2;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            n2 = this.u_stmt.getInt(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLong(int n) throws SQLException {
        long l;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            l = this.u_stmt.getLong(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float getFloat(int n) throws SQLException {
        float f;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            f = this.u_stmt.getFloat(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double getDouble(int n) throws SQLException {
        double d;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            d = this.u_stmt.getDouble(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            byArray = this.u_stmt.getBytes(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Date getDate(int n) throws SQLException {
        Date date;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            date = this.u_stmt.getDate(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Time getTime(int n) throws SQLException {
        Time time;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            time = this.u_stmt.getTime(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            timestamp = this.u_stmt.getTimestamp(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return timestamp;
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.checkIsOpen();
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        UniSQLInputStream uniSQLInputStream = new UniSQLInputStream(string.getBytes());
        this.addStream(uniSQLInputStream);
        return uniSQLInputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkIsOpen();
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        UniSQLInputStream uniSQLInputStream = new UniSQLInputStream(byArray);
        this.addStream(uniSQLInputStream);
        return uniSQLInputStream;
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    public synchronized String getCursorName() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.meta_data == null) {
            this.meta_data = new CUBRIDResultSetMetaData(this.u_stmt.getColumnInfo());
        }
        return this.meta_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(int n) throws SQLException {
        Object object;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            object = this.u_stmt.getObject(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return object;
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.checkIsOpen();
        for (int i = 0; i < this.column_info.length; ++i) {
            if (!this.column_info[i].getColumnName().equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_column_name);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkIsOpen();
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        UniSQLReader uniSQLReader = null;
        try {
            uniSQLReader = new UniSQLReader(new String(byArray, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.addStream(uniSQLReader);
        return uniSQLReader;
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            bigDecimal = this.u_stmt.getBigDecimal(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return bigDecimal;
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == -1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == this.number_of_rows;
    }

    public synchronized boolean isFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == 0;
    }

    public synchronized boolean isLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == this.number_of_rows - 1;
    }

    public synchronized void beforeFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.current_row = -1;
        this.inserting = false;
    }

    public synchronized void afterLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.current_row = this.number_of_rows;
        this.inserting = false;
    }

    public synchronized boolean first() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.inserting = false;
        this.current_row = 0;
        if (this.number_of_rows <= 0) {
            return false;
        }
        this.move();
        return true;
    }

    public synchronized boolean last() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.inserting = false;
        this.current_row = this.number_of_rows - 1;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        this.move();
        return true;
    }

    public synchronized int getRow() throws SQLException {
        this.checkIsOpen();
        if (this.current_row > -1 && this.current_row < this.number_of_rows) {
            return this.current_row + 1;
        }
        return 0;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        if (n == 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.argument_zero);
        }
        this.current_row = n > 0 ? n - 1 : this.number_of_rows + n;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        if (this.current_row >= this.number_of_rows) {
            this.current_row = this.number_of_rows;
            return false;
        }
        this.move();
        return true;
    }

    public synchronized boolean relative(int n) throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        if (this.current_row == -1 || this.current_row == this.number_of_rows) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
        }
        this.current_row += n;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        if (this.current_row >= this.number_of_rows) {
            this.current_row = this.number_of_rows;
            return false;
        }
        this.move();
        return true;
    }

    public synchronized boolean previous() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        --this.current_row;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        this.move();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFetchDirection(int n) throws SQLException {
        this.checkIsOpen();
        if (!this.is_scrollable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new IllegalArgumentException();
        }
        this.fetch_direction = n;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.setFetchDirection(n);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return this.fetch_direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fetch_size = n;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.setFetchSize(n);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    public synchronized int getType() throws SQLException {
        this.checkIsOpen();
        return this.type;
    }

    public synchronized int getConcurrency() throws SQLException {
        this.checkIsOpen();
        return this.concurrency;
    }

    public synchronized boolean rowUpdated() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        return false;
    }

    public synchronized boolean rowInserted() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rowDeleted() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        boolean bl = false;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            bl = this.u_stmt.cursorIsInstance(this.current_row);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        return !bl;
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.updateValue(n, null);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, new Boolean(bl));
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, new Byte(by));
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, new Short(s));
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, new Integer(n2));
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, new Long(l));
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, new Float(f));
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, new Double(d));
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, timestamp);
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(n);
        this.checkColumnIsUpdatable(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        if (n3 == -1) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.empty_inputstream);
        }
        this.updateValue(n, new String(byArray, 0, n3));
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(n);
        this.checkColumnIsUpdatable(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        if (n3 == -1) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.empty_inputstream);
        }
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
        }
        this.updateValue(n, byArray2);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(n);
        this.checkColumnIsUpdatable(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        try {
            n3 = reader.read(cArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        if (n3 == -1) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.empty_reader);
        }
        try {
            this.updateValue(n, new String(cArray, 0, n3).getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.updateObject(n, (Object)new BigDecimal(((Number)object).toString()).setScale(n2));
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.updateObject(n, object);
        }
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.updateValue(n, object);
    }

    public synchronized void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertRow() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLResultSet uniSQLResultSet = this;
                synchronized (uniSQLResultSet) {
                    int n;
                    this.checkIsOpen();
                    this.checkIsUpdatable();
                    if (!this.inserting) {
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
                    }
                    if (this.main_table_name == null) {
                        return;
                    }
                    String string = "insert into " + this.main_table_name + " (";
                    boolean bl = true;
                    for (n = 0; n < this.column_info.length; ++n) {
                        if (!this.updated[n]) continue;
                        if (!bl) {
                            string = string + ",";
                        }
                        bl = false;
                        string = string + this.column_info[n].getRealColumnName();
                    }
                    string = string + ") values (";
                    bl = true;
                    for (n = 0; n < this.column_info.length; ++n) {
                        if (!this.updated[n]) continue;
                        if (!bl) {
                            string = string + ",";
                        }
                        bl = false;
                        string = string + this.valueToString(this.updates[n]);
                    }
                    string = string + ")";
                    UStatement uStatement = this.con.prepare(string, (byte)0);
                    uStatement.execute(false, 0, 0, false, false, false);
                    this.error = uStatement.getRecentError();
                    uStatement.close();
                    if (this.error.getErrorCode() != 0) {
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.insertion_query_fail);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.checkIsOpen();
        }
    }

    public synchronized void updateRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForGet();
        int[] nArray = new int[this.number_of_updates];
        Object[] objectArray = new Object[this.number_of_updates];
        int n = 0;
        for (int i = 0; i < this.column_info.length; ++i) {
            if (!this.updated[i]) continue;
            nArray[n] = i;
            objectArray[n++] = this.updates[i];
        }
        this.u_stmt.updateRows(this.current_row, nArray, objectArray);
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        if (this.is_sensitive) {
            this.refreshRow();
        } else {
            this.clearCurrentRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForGet();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.u_stmt.deleteCursor(this.current_row);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    public synchronized void refreshRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        this.clearCurrentRow();
        this.u_stmt.reFetch();
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.number_of_updates = 0;
        for (int i = 0; i < this.updates.length; ++i) {
            this.updates[i] = null;
            this.updated[i] = false;
        }
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.clearCurrentRow();
        this.inserting = true;
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.clearCurrentRow();
        this.inserting = false;
    }

    public synchronized Statement getStatement() throws SQLException {
        this.checkIsOpen();
        return this.stmt;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Blob getBlob(int n) throws SQLException {
        UniSQLOID uniSQLOID;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            uniSQLOID = this.u_stmt.getGloOID(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        if (uniSQLOID == null) {
            return null;
        }
        return new CUBRIDBlob(uniSQLOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        UniSQLOID uniSQLOID;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            uniSQLOID = this.u_stmt.getGloOID(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        if (uniSQLOID == null) {
            return null;
        }
        return new CUBRIDClob(uniSQLOID, this.con.getUConnection().getCharset());
    }

    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    public synchronized URL getURL(int n) throws SQLException {
        return null;
    }

    public synchronized URL getURL(String string) throws SQLException {
        return null;
    }

    public synchronized void updateArray(int n, Array array) throws SQLException {
    }

    public synchronized void updateArray(String string, Array array) throws SQLException {
    }

    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        this.updateValue(n, blob);
    }

    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        this.updateValue(this.findColumn(string), blob);
    }

    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        this.updateValue(n, clob);
    }

    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        this.updateValue(this.findColumn(string), clob);
    }

    public synchronized void updateRef(int n, Ref ref) throws SQLException {
    }

    public synchronized void updateRef(String string, Ref ref) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UniSQLOID getOID(int n) throws SQLException {
        UniSQLOID uniSQLOID;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            uniSQLOID = this.u_stmt.getColumnOID(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return uniSQLOID;
    }

    public synchronized UniSQLOID getOID(String string) throws SQLException {
        return this.getOID(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getCollection(int n) throws SQLException {
        Object object;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            object = this.u_stmt.getCollection(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return object;
    }

    public synchronized Object getCollection(String string) throws SQLException {
        return this.getCollection(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UniSQLOID getOID() throws SQLException {
        this.checkIsOpen();
        this.checkRowIsValidForGet();
        UniSQLOID uniSQLOID = null;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            uniSQLOID = this.u_stmt.getCursorOID();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                return uniSQLOID;
            }
            case 21: {
                return null;
            }
        }
        throw new CUBRIDException(this.error);
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.result_set_closed);
        }
    }

    private void checkIsUpdatable() throws SQLException {
        if (!this.is_updatable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
        }
    }

    private void checkIsSensitive() throws SQLException {
        if (!this.is_sensitive) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
        }
    }

    private void checkIsScrollable() throws SQLException {
        if (!this.is_scrollable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
        }
    }

    private void checkRowIsValidForGet() throws SQLException {
        if (this.current_row == this.number_of_rows || this.current_row == -1 || this.inserting) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
        }
    }

    private void checkRowIsValidForUpdate() throws SQLException {
        if (!(this.current_row != this.number_of_rows && this.current_row != -1 || this.inserting)) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
        }
    }

    private void checkColumnIsValid(int n) throws SQLException {
        if (n < 1 || n > this.column_info.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
    }

    private void checkColumnIsUpdatable(int n) throws SQLException {
        if (!this.updatable[n - 1]) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable_column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeGetValue(int n) throws SQLException {
        this.checkRowIsValidForGet();
        this.checkColumnIsValid(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    private void checkGetXXXError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                this.was_null = false;
                break;
            }
            case 8: {
                this.was_null = true;
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    private void updateValue(int n, Object object) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(n);
        this.checkColumnIsUpdatable(n);
        this.updates[n - 1] = object;
        if (!this.updated[n - 1]) {
            this.updated[n - 1] = true;
            ++this.number_of_updates;
        }
    }

    protected void clearCurrentRow() throws SQLException {
        Iterator iterator = this.streams.iterator();
        try {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof UniSQLInputStream) {
                    ((InputStream)e).close();
                } else {
                    ((Reader)e).close();
                }
                iterator.remove();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.is_updatable) {
            this.number_of_updates = 0;
            for (int i = 0; i < this.updates.length; ++i) {
                this.updates[i] = null;
                this.updated[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move() throws SQLException {
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.moveCursor(this.current_row, 0);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    private void addStream(Object object) throws SQLException {
        this.streams.add(object);
    }

    private String valueToString(Object object) throws SQLException {
        if (object == null) {
            return "null";
        }
        String string = null;
        if (object instanceof Time) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            string = "'" + simpleDateFormat.format((java.util.Date)object) + "'";
        } else if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            string = "'" + simpleDateFormat.format((java.util.Date)object) + "'";
        } else if (object instanceof Timestamp) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            string = "'" + simpleDateFormat.format((java.util.Date)object) + "'";
        } else if (object instanceof UniSQLOID) {
            string = "'" + ((UniSQLOID)object).getOidString() + "'";
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            string = "";
            for (int i = byArray.length - 1; i >= 0; --i) {
                int n = byArray[i] + 256;
                for (int j = 0; j < 2; ++j) {
                    if (n % 16 < 10) {
                        string = n % 16 + string;
                    }
                    if (n % 16 == 10) {
                        string = "A" + string;
                    }
                    if (n % 16 == 11) {
                        string = "B" + string;
                    }
                    if (n % 16 == 12) {
                        string = "C" + string;
                    }
                    if (n % 16 == 13) {
                        string = "D" + string;
                    }
                    if (n % 16 == 14) {
                        string = "E" + string;
                    }
                    if (n % 16 == 15) {
                        string = "F" + string;
                    }
                    n /= 16;
                }
            }
            string = "X'" + string + "'";
        } else if (object instanceof String) {
            string = "'" + object.toString() + "'";
        } else if (object instanceof Boolean) {
            string = "B'";
            string = string + ((Boolean)object != false ? "1" : "0");
            string = string + "'";
        } else {
            string = object.toString();
        }
        return string;
    }

    public int getServerHandle() {
        if (this.u_stmt == null || !this.u_stmt.isReturnable()) {
            return 0;
        }
        return this.u_stmt.getServerHandle();
    }

    public void setReturnable() {
        if (!this.is_closed) {
            this.u_stmt.setReturnable();
        }
    }
}

