/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.IOException;
import java.io.Reader;

class UniSQLReader
extends Reader {
    private int position;
    private String valueBuffer;

    UniSQLReader(String string) {
        this.valueBuffer = string;
        this.position = 0;
    }

    public synchronized int available() throws IOException {
        if (this.valueBuffer == null) {
            return 0;
        }
        return this.valueBuffer.length() - this.position;
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.valueBuffer == null) {
            return -1;
        }
        for (n3 = this.position; n3 < n2 + this.position && n3 < this.valueBuffer.length(); ++n3) {
            cArray[n3 - this.position + n] = this.valueBuffer.charAt(n3);
        }
        int n4 = this.position;
        this.position = n3;
        if (this.position == this.valueBuffer.length()) {
            this.close();
        }
        return n3 - n4;
    }

    public synchronized void close() throws IOException {
        this.valueBuffer = null;
    }

    public boolean ready() {
        return true;
    }
}

