/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLStatement;
import unisql.jdbc.jci.UBatchResult;
import unisql.jdbc.jci.UColumnInfo;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UStatement;
import unisql.sql.UniSQLOID;

public class UniSQLPreparedStatement
extends UniSQLStatement
implements PreparedStatement {
    private boolean first_result_type;

    protected UniSQLPreparedStatement(UniSQLConnection uniSQLConnection, UStatement uStatement, int n, int n2) {
        super(uniSQLConnection, n, n2);
        this.u_stmt = uStatement;
        this.first_result_type = this.u_stmt.getSqlType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    if (!this.first_result_type && this.u_stmt.getCommandType() != 126) {
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeQuery);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    if (this.current_result_set != null) {
                        this.current_result_set.complete_on_close = true;
                    }
                    return this.current_result_set;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    if (this.first_result_type) {
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeUpdate);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    if (this.u_stmt.getCommandType() != 126) {
                        this.complete();
                    }
                    return this.update_count;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNull(int n, int n2) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindNull(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, bl);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setByte(int n, byte by) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, by);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setShort(int n, short s) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, s);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInt(int n, int n2) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, n2);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLong(int n, long l) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, l);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFloat(int n, float f) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, f);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDouble(int n, double d) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, d);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, bigDecimal);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setString(int n, String string) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, string);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, byArray);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDate(int n, Date date) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, date);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTime(int n, Time time) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, time);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, timestamp);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        if (inputStream == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(n - 1, inputStream);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, new String(byArray, 0, n3));
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        if (inputStream == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(n - 1, inputStream);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, byArray2);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearParameters() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.clearBind();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            if (n2 == 2 || n2 == 3) {
                Number number = null;
                try {
                    number = (Number)object;
                }
                catch (Exception exception) {
                    this.u_stmt.bind(n - 1, object);
                }
                this.u_stmt.bind(n - 1, new BigDecimal(number.toString()).setScale(n3));
            } else {
                this.u_stmt.bind(n - 1, object);
            }
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setObject(int n, Object object) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, object);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    this.executeCore(true);
                    this.getMoreResults();
                    return this.first_result_type;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addBatch() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.addBatch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIsOpen();
        if (reader == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(n - 1, reader);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        try {
            n3 = reader.read(cArray);
        }
        catch (IOException iOException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(n - 1, new String(cArray, 0, n3));
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (!(blob instanceof UniSQLOID)) {
            throw new IllegalArgumentException();
        }
        this.setOID(n, (UniSQLOID)((Object)blob));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (!(clob instanceof UniSQLOID)) {
            throw new IllegalArgumentException();
        }
        this.setOID(n, (UniSQLOID)((Object)clob));
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        UColumnInfo[] uColumnInfoArray = null;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            uColumnInfoArray = this.u_stmt.getColumnInfo();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        if (uColumnInfoArray.length == 0) {
            return null;
        }
        return new CUBRIDResultSetMetaData(uColumnInfoArray);
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    if (this.is_closed) {
                        return;
                    }
                    this.is_closed = true;
                    this.complete();
                    if (this.u_stmt != null) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                    }
                    this.con = null;
                    this.u_con = null;
                    this.error = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearBatch() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.clearBatch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    UBatchResult uBatchResult = this.u_stmt.executeBatch();
                    this.error = this.u_stmt.getRecentError();
                    switch (this.error.getErrorCode()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw new CUBRIDException(this.error);
                        }
                    }
                    this.con.autoCommit();
                    return this.checkBatchResult(uBatchResult);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setURL(int n, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setOID(int n, UniSQLOID uniSQLOID) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindOID(n - 1, uniSQLOID);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public synchronized void setOID(int n, CUBRIDOID cUBRIDOID) throws SQLException {
        this.setOID(n, (UniSQLOID)cUBRIDOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCollection(int n, Object[] objectArray) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindCollection(n - 1, objectArray);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniSQLOID executeInsert() throws SQLException {
        try {
            UniSQLConnection uniSQLConnection = this.con;
            synchronized (uniSQLConnection) {
                UniSQLPreparedStatement uniSQLPreparedStatement = this;
                synchronized (uniSQLPreparedStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    UniSQLOID uniSQLOID = this.executeInsertCore();
                    this.complete();
                    return uniSQLOID;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    public boolean hasResultSet() {
        return this.first_result_type;
    }

    void complete() throws SQLException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.current_result_set != null) {
            this.current_result_set.close();
            this.current_result_set = null;
        }
        this.result_info = null;
        this.con.autoCommit();
    }

    protected void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    protected void checkBindError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case 6: {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
            }
            case 16: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    private void checkExecuteError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                UError uError = new UError(this.error);
                this.con.autoRollback();
                throw new CUBRIDException(uError);
            }
        }
    }
}

