/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionWrapperPooling;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.jci.UConnection;

public class UniSQLPooledConnection
implements PooledConnection {
    protected UConnection u_con;
    protected boolean isClosed = false;
    protected UniSQLConnection curConnection = null;
    private Vector eventListeners = new Vector();

    protected UniSQLPooledConnection() {
    }

    protected UniSQLPooledConnection(UConnection uConnection) {
        this();
        this.u_con = uConnection;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.pooled_connection_closed);
        }
        if (this.curConnection != null) {
            this.curConnection.closeConnection();
        }
        if (!this.u_con.check_cas()) {
            this.u_con.reset_connection();
        }
        this.curConnection = new CUBRIDConnectionWrapperPooling(this.u_con, null, null, this);
        return this.curConnection;
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curConnection != null) {
            this.curConnection.closeConnection();
        }
        this.u_con.close();
        this.eventListeners.clear();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.isClosed) {
            return;
        }
        this.eventListeners.addElement(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.isClosed) {
            return;
        }
        this.eventListeners.removeElement(connectionEventListener);
    }

    synchronized void notifyConnectionClosed() {
        this.curConnection = null;
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((ConnectionEventListener)this.eventListeners.elementAt(i)).connectionClosed(connectionEvent);
        }
    }

    synchronized void notifyConnectionErrorOccurred(SQLException sQLException) {
        this.curConnection = null;
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((ConnectionEventListener)this.eventListeners.elementAt(i)).connectionErrorOccurred(connectionEvent);
        }
    }
}

