/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import unisql.jdbc.driver.UniSQLClob;

class UniSQLGloWriter
extends Writer {
    private static final int CHAR_BUFFER_SIZE = 8192;
    private UniSQLClob clob;
    private int clob_pos;
    private int buf_position;
    private char[] data_buffer;

    UniSQLGloWriter(UniSQLClob uniSQLClob, int n) {
        this.clob = uniSQLClob;
        this.clob_pos = n;
        this.data_buffer = new char[8192];
        this.buf_position = 0;
    }

    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        if (this.clob == null || cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < 8192 - this.buf_position) {
            System.arraycopy(cArray, n, this.data_buffer, this.buf_position, n2);
            this.buf_position += n2;
            return;
        }
        if (this.buf_position > 0) {
            int n3 = 8192 - this.buf_position;
            System.arraycopy(cArray, n, this.data_buffer, this.buf_position, n3);
            this.write_data(this.data_buffer, 0, 8192);
            n += n3;
            n2 -= n3;
            this.buf_position = 0;
        }
        if (n2 >= 8192) {
            this.write_data(cArray, n, n2);
            return;
        }
        System.arraycopy(cArray, n, this.data_buffer, this.buf_position, n2);
        this.buf_position += n2;
    }

    public synchronized void flush() throws IOException {
        if (this.clob == null) {
            return;
        }
        if (this.buf_position > 0) {
            this.write_data(this.data_buffer, 0, this.buf_position);
            this.buf_position = 0;
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.clob = null;
    }

    private void write_data(char[] cArray, int n, int n2) throws IOException {
        try {
            this.clob.setString(this.clob_pos, new String(cArray, n, n2));
            this.clob_pos += n2;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

