/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import unisql.jdbc.driver.UniSQLClob;

class UniSQLGloReader
extends Reader {
    private static final int CHAR_BUFFER_SIZE = 8192;
    private UniSQLClob u_clob;
    private int buf_position;
    private int clob_pos;
    private int unread_size;
    private char[] data_buffer;

    UniSQLGloReader(UniSQLClob uniSQLClob) {
        this.u_clob = uniSQLClob;
        this.data_buffer = new char[8192];
        this.unread_size = 0;
        this.buf_position = 0;
        this.clob_pos = 1;
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        if (this.u_clob == null && this.unread_size <= 0) {
            return -1;
        }
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= this.unread_size) {
            System.arraycopy(this.data_buffer, this.buf_position, cArray, n, n2);
            this.unread_size -= n2;
            this.buf_position += n2;
            return n2;
        }
        int n3 = this.unread_size;
        if (this.unread_size > 0) {
            System.arraycopy(this.data_buffer, this.buf_position, cArray, n, n3);
            n += n3;
            n2 -= n3;
            this.unread_size = 0;
            this.buf_position = 0;
        }
        if (n2 >= 8192) {
            return n3 + this.read_data(n2, cArray, n);
        }
        this.unread_size = this.read_data(8192, this.data_buffer, 0);
        this.buf_position = 0;
        if (n2 > this.unread_size) {
            n2 = this.unread_size;
        }
        System.arraycopy(this.data_buffer, 0, cArray, n, n2);
        this.buf_position += n2;
        this.unread_size -= n2;
        return n3 + n2;
    }

    public synchronized void close() throws IOException {
        this.u_clob = null;
    }

    public synchronized boolean ready() {
        return this.unread_size > 0;
    }

    private int read_data(int n, char[] cArray, int n2) throws IOException {
        int n3;
        if (this.u_clob == null) {
            return 0;
        }
        try {
            n3 = this.u_clob.getChars(this.clob_pos, n, cArray, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.clob_pos += n3;
        if (n3 < n) {
            this.u_clob = null;
        }
        return n3;
    }
}

