/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import unisql.sql.UniSQLOID;

class UniSQLGloOutputStream
extends OutputStream {
    private static final int BYTE_BUFFER_SIZE = 16000;
    private UniSQLOID oid;
    private int glo_pos;
    private int buf_position;
    private byte[] data_buffer;
    private byte[] write_byte_buf;

    UniSQLGloOutputStream(UniSQLOID uniSQLOID, int n) {
        this.oid = uniSQLOID;
        this.glo_pos = n;
        this.data_buffer = new byte[16000];
        this.buf_position = 0;
        this.write_byte_buf = new byte[1];
    }

    public synchronized void write(int n) throws IOException {
        this.write_byte_buf[0] = (byte)n;
        this.write(this.write_byte_buf, 0, 1);
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.oid == null || byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < 16000 - this.buf_position) {
            System.arraycopy(byArray, n, this.data_buffer, this.buf_position, n2);
            this.buf_position += n2;
            return;
        }
        if (this.buf_position > 0) {
            int n3 = 16000 - this.buf_position;
            System.arraycopy(byArray, n, this.data_buffer, this.buf_position, n3);
            this.write_data(this.data_buffer, 0, 16000);
            n += n3;
            n2 -= n3;
            this.buf_position = 0;
        }
        while (n2 >= 16000) {
            this.write_data(byArray, n, 16000);
            n += 16000;
            n2 -= 16000;
        }
        System.arraycopy(byArray, n, this.data_buffer, this.buf_position, n2);
        this.buf_position += n2;
    }

    public synchronized void flush() throws IOException {
        if (this.oid == null) {
            return;
        }
        if (this.buf_position <= 0) {
            return;
        }
        this.write_data(this.data_buffer, 0, this.buf_position);
        this.buf_position = 0;
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.oid = null;
    }

    private void write_data(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.oid.gloWrite(this.glo_pos, byArray, n, n2);
            this.glo_pos += n2;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

