/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import unisql.sql.UniSQLOID;

class UniSQLGloInputStream
extends InputStream {
    private static final int BYTE_BUFFER_SIZE = 16000;
    private UniSQLOID oid;
    private long glo_pos;
    private int unread_size;
    private int buf_position;
    private byte[] data_buffer;
    private byte[] read_byte_buf;

    UniSQLGloInputStream(UniSQLOID uniSQLOID) {
        this.oid = uniSQLOID;
        this.data_buffer = new byte[16000];
        this.unread_size = 0;
        this.buf_position = 0;
        this.glo_pos = 1L;
        this.read_byte_buf = new byte[1];
    }

    public synchronized int available() throws IOException {
        return this.unread_size;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.read_byte_buf, 0, 1) == 1) {
            return 0xFF & this.read_byte_buf[0];
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.oid == null && this.unread_size <= 0) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= this.unread_size) {
            System.arraycopy(this.data_buffer, this.buf_position, byArray, n, n2);
            this.unread_size -= n2;
            this.buf_position += n2;
            return n2;
        }
        int n3 = 0;
        if (this.unread_size > 0) {
            n3 = this.unread_size;
            System.arraycopy(this.data_buffer, this.buf_position, byArray, n, n3);
            n += n3;
            n2 -= n3;
            this.unread_size = 0;
            this.buf_position += n3;
        }
        while (n2 >= 16000) {
            int n4 = this.read_data(16000, byArray, n);
            if (n4 < 16000) {
                return n3 + n4;
            }
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        this.unread_size = this.read_data(16000, this.data_buffer, 0);
        this.buf_position = 0;
        if (n2 > this.unread_size) {
            n2 = this.unread_size;
        }
        System.arraycopy(this.data_buffer, this.buf_position, byArray, n, n2);
        this.unread_size -= n2;
        this.buf_position += n2;
        return n3 + n2;
    }

    public synchronized long skip(long l) throws IOException {
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        if (l <= (long)this.unread_size) {
            this.unread_size = (int)((long)this.unread_size - l);
            this.buf_position = (int)((long)this.buf_position + l);
            return l;
        }
        l -= (long)this.unread_size;
        long l3 = this.unread_size;
        this.unread_size = 0;
        if (this.oid == null) {
            return l3;
        }
        try {
            l2 = this.oid.gloSize() - this.glo_pos + 1L;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        if (l > l2) {
            l = l2;
            this.oid = null;
        }
        this.glo_pos += l;
        return l3 += l;
    }

    public synchronized void close() throws IOException {
        this.oid = null;
    }

    private int read_data(int n, byte[] byArray, int n2) throws IOException {
        int n3;
        if (this.oid == null) {
            return 0;
        }
        try {
            n3 = this.oid.gloRead(this.glo_pos, n, byArray, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.glo_pos += (long)n3;
        if (n3 < n) {
            this.oid = null;
        }
        return n3;
    }
}

