/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Date;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class UniSQLDataSourceBase {
    private String databaseName = "";
    private String dataSourceName = "";
    private String description = "";
    private String networkProtocol = "";
    private String password = "";
    private int portNumber = 0;
    private String roleName = "";
    private String serverName = "";
    private String user = "public";
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private String dataSourceID = null;

    protected UniSQLDataSourceBase() {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setNetworkProtocol(String string) {
        this.networkProtocol = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    synchronized String getDataSourceID(String string) {
        if (this.dataSourceID == null) {
            try {
                this.dataSourceID = InetAddress.getByName(this.serverName).getHostAddress();
            }
            catch (Exception exception) {
                this.dataSourceID = this.serverName;
            }
            this.dataSourceID = this.dataSourceID + ":" + this.portNumber + ":" + this.databaseName;
        }
        return this.dataSourceID + ":" + string;
    }

    protected Reference getProperties(Reference reference) {
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("portNumber", Integer.toString(this.getPortNumber())));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("roleName", this.getRoleName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        return reference;
    }

    protected void setProperties(Reference reference) {
        this.setServerName((String)reference.get("serverName").getContent());
        this.setDatabaseName((String)reference.get("databaseName").getContent());
        this.setPortNumber(Integer.parseInt((String)reference.get("portNumber").getContent()));
        this.setDataSourceName((String)reference.get("dataSourceName").getContent());
        this.setDescription((String)reference.get("description").getContent());
        this.setNetworkProtocol((String)reference.get("networkProtocol").getContent());
        this.setPassword((String)reference.get("password").getContent());
        this.setRoleName((String)reference.get("roleName").getContent());
        this.setUser((String)reference.get("user").getContent());
    }

    protected void writeLog(String string) {
        if (this.logWriter != null) {
            Date date = new Date(System.currentTimeMillis());
            this.logWriter.println("[" + date + "] " + string);
            this.logWriter.flush();
        }
    }
}

