/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.SQLException;
import java.sql.Savepoint;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLXAConnection;
import unisql.jdbc.jci.UConnection;

public class UniSQLConnectionWrapperXA
extends UniSQLConnection {
    private UniSQLXAConnection xacon;
    private boolean xa_started;

    protected UniSQLConnectionWrapperXA(UConnection uConnection, String string, String string2, UniSQLXAConnection uniSQLXAConnection, boolean bl) {
        super(uConnection, string, string2);
        this.xacon = uniSQLXAConnection;
        this.xa_started = bl;
        if (bl) {
            this.auto_commit = false;
        }
    }

    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.closeConnection();
        this.xacon.notifyConnectionClosed();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.xa_started) {
            if (bl) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
            }
        } else {
            super.setAutoCommit(bl);
        }
    }

    public synchronized void commit() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.commit();
    }

    public synchronized void rollback() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.rollback();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.rollback(savepoint);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.xa_started) {
            super.releaseSavepoint(savepoint);
        }
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        return super.setSavepoint();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        return super.setSavepoint(string);
    }

    void autoCommit() throws SQLException {
        if (!this.xa_started) {
            super.autoCommit();
        }
    }

    void xa_start(UConnection uConnection) {
        if (this.xa_started) {
            return;
        }
        this.auto_commit = false;
        this.xa_started = true;
        if (uConnection != null) {
            this.u_con = uConnection;
        }
    }

    void xa_end(UConnection uConnection) {
        if (!this.xa_started) {
            return;
        }
        this.xa_started = false;
        if (uConnection != null) {
            this.u_con = uConnection;
        }
        this.auto_commit = true;
    }
}

