/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDCallableStatement;
import cubrid.jdbc.driver.CUBRIDDatabaseMetaData;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDOutResultSet;
import cubrid.jdbc.driver.CUBRIDPreparedStatement;
import cubrid.jdbc.driver.CUBRIDStatement;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import unisql.jdbc.driver.UniSQLDatabaseMetaData;
import unisql.jdbc.driver.UniSQLPreparedStatement;
import unisql.jdbc.driver.UniSQLStatement;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UStatement;
import unisql.sql.UniSQLOID;

public class UniSQLConnection
implements Connection {
    public static final int TRAN_REP_CLASS_REP_INSTANCE = 4;
    public static final int TRAN_REP_CLASS_COMMIT_INSTANCE = 16;
    public static final int TRAN_REP_CLASS_UNCOMMIT_INSTANCE = 32;
    public static final int TRAN_COMMIT_CLASS_COMMIT_INSTANCE = 2;
    public static final int TRAN_COMMIT_CLASS_UNCOMMIT_INSTANCE = 1;
    public static final int TRAN_SERIALIZABLE = 8;
    UConnection u_con;
    String user;
    String url;
    protected boolean is_closed;
    protected boolean auto_commit;
    private UError error;
    private boolean ending;
    private ArrayList statements;
    private UniSQLDatabaseMetaData mdata;
    private boolean isServerSideJdbc;
    private ArrayList outRs;

    protected UniSQLConnection(UConnection uConnection, String string, String string2) {
        this.u_con = uConnection;
        this.u_con.setUniSQLConnection(this);
        this.url = string;
        this.user = string2;
        this.is_closed = false;
        this.auto_commit = true;
        this.error = null;
        this.mdata = null;
        this.ending = false;
        this.statements = new ArrayList();
        this.outRs = new ArrayList();
        this.isServerSideJdbc = false;
    }

    public UniSQLConnection(UConnection uConnection, String string, String string2, boolean bl) {
        this(uConnection, string, string2);
        if (bl) {
            this.auto_commit = false;
            this.isServerSideJdbc = true;
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.prepare(string, (byte)64);
        CUBRIDCallableStatement cUBRIDCallableStatement = new CUBRIDCallableStatement(this, uStatement);
        this.addStatement(cUBRIDCallableStatement);
        return cUBRIDCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkIsOpen();
        if (!this.isServerSideJdbc) {
            if (this.auto_commit != bl) {
                this.commit();
            }
            this.auto_commit = bl;
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkIsOpen();
        return this.auto_commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws SQLException {
        this.checkIsOpen();
        if (this.ending) {
            return;
        }
        this.ending = true;
        if (!this.isServerSideJdbc) {
            this.completeAllStatements();
            try {
                this.end(true);
            }
            finally {
                this.ending = false;
            }
        }
        this.ending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SQLException {
        this.checkIsOpen();
        if (this.ending) {
            return;
        }
        this.ending = true;
        if (!this.isServerSideJdbc) {
            this.completeAllStatements();
            try {
                this.end(false);
            }
            finally {
                this.ending = false;
            }
        }
        this.ending = false;
    }

    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.clear();
        this.is_closed = true;
        this.u_con.close();
        this.u_con = null;
        this.url = null;
        this.user = null;
        this.mdata = null;
        this.statements = null;
        this.error = null;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.is_closed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.mdata != null) {
            return this.mdata;
        }
        this.mdata = new CUBRIDDatabaseMetaData(this);
        return this.mdata;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkIsOpen();
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.checkIsOpen();
    }

    public synchronized String getCatalog() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        int n2;
        this.checkIsOpen();
        this.commit();
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
            case 8: {
                n2 = 6;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 3;
                break;
            }
            default: {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_trans_iso_level);
            }
        }
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.setIsolationLevel(n2);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkIsOpen();
        int n = 0;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            n = this.u_con.getIsolationLevel();
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        switch (n) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 32;
            }
            case 6: {
                return 8;
            }
        }
        return 0;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkIsOpen();
        CUBRIDStatement cUBRIDStatement = new CUBRIDStatement(this, n, n2);
        this.addStatement(cUBRIDStatement);
        return cUBRIDStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIsOpen();
        byte by = 0;
        if (n == 1005 || n2 == 1008) {
            by = 2;
        }
        UStatement uStatement = this.prepare(string, by);
        CUBRIDPreparedStatement cUBRIDPreparedStatement = new CUBRIDPreparedStatement(this, uStatement, n, n2);
        this.addStatement(cUBRIDPreparedStatement);
        return cUBRIDPreparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string);
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.createStatement(n, n2);
    }

    public synchronized int getHoldability() throws SQLException {
        return 2;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareCall(string);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(string);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n, n2);
    }

    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string);
    }

    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setHoldability(int n) throws SQLException {
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setCharset(String string) throws UnsupportedEncodingException {
        this.u_con.setCharset(string);
    }

    public synchronized UniSQLOID getNewGLO(String string, InputStream inputStream) throws SQLException {
        this.checkIsOpen();
        UniSQLOID uniSQLOID = this.newGloLo(string);
        uniSQLOID.saveGLO(inputStream);
        return uniSQLOID;
    }

    public synchronized UniSQLOID getNewGLO(String string, InputStream inputStream, int n) throws SQLException {
        this.checkIsOpen();
        UniSQLOID uniSQLOID = this.newGloLo(string);
        uniSQLOID.saveGLO(inputStream, n);
        return uniSQLOID;
    }

    public synchronized UniSQLOID newGloLo(String string) throws SQLException {
        return this.newGlo(string, (byte)1, null);
    }

    public synchronized UniSQLOID newGloFbo(String string, String string2) throws SQLException {
        return this.newGlo(string, (byte)2, string2);
    }

    public synchronized UConnection getUConnection() throws SQLException {
        this.checkIsOpen();
        return this.u_con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLockTimeout(int n) throws SQLException {
        this.checkIsOpen();
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.setLockTimeout(n);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UStatement prepare(String string, byte by) throws SQLException {
        UStatement uStatement = null;
        Object object = this.u_con;
        synchronized (object) {
            uStatement = this.u_con.prepare(string, by);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                return uStatement;
            }
        }
        object = new UError(this.error);
        this.autoRollback();
        throw new CUBRIDException((UError)object);
    }

    void autoCommit() throws SQLException {
        this.checkIsOpen();
        if (this.auto_commit) {
            this.commit();
        }
    }

    void autoRollback() throws SQLException {
        this.checkIsOpen();
        if (this.auto_commit) {
            this.rollback();
        }
    }

    synchronized void closeConnection() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.clear();
        this.is_closed = true;
    }

    private void clear() throws SQLException {
        this.closeAllStatements();
        this.closeAllOutResultSet();
        if (this.mdata != null) {
            this.mdata.close();
        }
        this.mdata = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.connection_closed);
        }
    }

    private void addStatement(Statement statement) throws SQLException {
        this.statements.add(statement);
    }

    private void completeAllStatements() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            UniSQLStatement uniSQLStatement = (UniSQLStatement)this.statements.get(i);
            if (uniSQLStatement instanceof UniSQLPreparedStatement) {
                uniSQLStatement.close();
                this.statements.remove(i);
                continue;
            }
            uniSQLStatement.complete();
        }
    }

    private void closeAllStatements() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            UniSQLStatement uniSQLStatement = (UniSQLStatement)this.statements.get(i);
            uniSQLStatement.close();
        }
        this.statements.clear();
    }

    private void closeAllOutResultSet() throws SQLException {
        for (int i = 0; i < this.outRs.size(); ++i) {
            CUBRIDOutResultSet cUBRIDOutResultSet = (CUBRIDOutResultSet)this.outRs.get(i);
            cUBRIDOutResultSet.close();
        }
        this.outRs.clear();
    }

    public void addOutResultSet(CUBRIDOutResultSet cUBRIDOutResultSet) {
        this.outRs.add(cUBRIDOutResultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(boolean bl) throws SQLException {
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.endTransaction(bl);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UniSQLOID newGlo(String string, byte by, String string2) throws SQLException {
        this.checkIsOpen();
        UniSQLOID uniSQLOID = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            uniSQLOID = this.u_con.gloNew(string, by, string2);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        return uniSQLOID;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

