/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int m_rmid = -1;

    public OracleXAHeteroResource(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    private void checkStatus(int n) throws XAException {
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = bl ? 0x40000000 : 0;
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n3 = this.do_xa_commit(n2, byArray, byArray2, this.m_rmid, n, 0);
        super.resumeStacked(xid2);
        this.checkStatus(n3);
    }

    private native int do_xa_commit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_end(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_forget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_prepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_rollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_start(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    public void end(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid, n);
        super.pop();
        int n3 = this.do_xa_end(n2, byArray, byArray2, this.m_rmid, n, 0);
        super.resumeStacked(xid2);
        this.checkStatus(n3);
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.do_xa_forget(n, byArray, byArray2, this.m_rmid, 0, 0);
        this.checkStatus(n2);
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n2 = this.do_xa_prepare(n, byArray, byArray2, this.m_rmid, 0, 0);
        super.resumeStacked(xid2);
        if (n2 != 0 && n2 != 3) {
            this.checkStatus(n2);
        }
        return n2;
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n2 = this.do_xa_rollback(n, byArray, byArray2, this.m_rmid, 0, 0);
        super.resumeStacked(xid2);
        this.checkStatus(n2);
    }

    synchronized void setRmid(int n) {
        this.m_rmid = n;
    }

    public void start(Xid xid, int n) throws XAException {
        this.disallowLocalTxnMode(-6);
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = n & 0xFF00;
        if ((n &= 0xFFFF00FF) != 0 && n != 0x8000000 && n != 0x200000 && (n & 2) != 2) {
            throw new XAException(-5);
        }
        if ((n2 & 0xFF00) != 0 && n2 != 256 && n2 != 512 && n2 != 1024) {
            throw new XAException(-5);
        }
        if ((n2 & 0xFF00) != 0 && (n & 0x8200000) != 0) {
            throw new XAException(-5);
        }
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.do_xa_start(n3, byArray, byArray2, this.m_rmid, n |= n2, 0);
        this.checkStatus(n4);
        super.push(xid);
    }
}

