/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;

public class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 4096;
    DBConversion db_conversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;

    public OracleConversionReader(DBConversion dBConversion, InputStream inputStream, int n) throws SQLException {
        if (dBConversion == null || inputStream == null || n != 8 && n != 9) {
            DBError.throwSqlException(68);
        }
        this.db_conversion = dBConversion;
        this.conversion = n;
        this.istream = inputStream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        if (n == 8) {
            this.byteBuf = new byte[2048];
            this.buf = new char[4096];
        } else if (n == 9) {
            this.byteBuf = new byte[4096];
            this.buf = new char[4096];
        }
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.istream.close();
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    int n = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                    if (n == -1) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            DBError.throwSqlException(55);
                        }
                    }
                    if ((n += this.numUnconvertedBytes) > 0) {
                        switch (this.conversion) {
                            case 8: {
                                this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, n, this.buf);
                                break;
                            }
                            case 9: {
                                int[] nArray = new int[]{n};
                                this.count = this.csform == 2 ? this.db_conversion.NCHARBytesToJavaChars(this.byteBuf, nArray, this.buf) : this.db_conversion.CHARBytesToJavaChars(this.byteBuf, nArray, this.buf);
                                this.numUnconvertedBytes = nArray[0];
                                int n2 = 0;
                                while (n2 < this.numUnconvertedBytes) {
                                    this.byteBuf[n2] = this.byteBuf[n - this.numUnconvertedBytes + n2];
                                    ++n2;
                                }
                                break;
                            }
                            default: {
                                DBError.throwSqlException(23);
                            }
                        }
                        if (this.count > 0) {
                            this.pos = 0;
                            return true;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n3 = n;
        int n4 = n3 + Math.min(n2, cArray.length - n);
        n3 += this.writeChars(cArray, n3, n4 - n3);
        while (n3 < n4 && this.needChars()) {
            n3 += this.writeChars(cArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void setFormOfUse(short s) {
        this.csform = s;
    }

    protected int writeChars(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n, n3);
        this.pos += n3;
        return n3;
    }
}

