/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitMaskBuf;

public class ReplaceIMGBuf {
    private ReplaceIMGBuf() {
    }

    public static short[][] ReplaceShortGrayIMGBuf(short[][] Image2, short oldConstant, short newConstant) throws ImageGSException {
        short[][] TargetGrayIMGBuf = null;
        if (Image2 == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0 || oldConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0 || newConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image2);
            int width = GetSizeIMG.getWidth(Image2);
            TargetGrayIMGBuf = InitMaskBuf.ShortInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image2[i][j] == oldConstant ? newConstant : Image2[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }

    public static int[][] ReplaceIntegerGrayIMGBuf(int[][] Image2, int oldConstant, int newConstant) throws ImageGSException {
        int[][] TargetGrayIMGBuf = null;
        if (Image2 == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0 || oldConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0 || newConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image2);
            int width = GetSizeIMG.getWidth(Image2);
            TargetGrayIMGBuf = InitMaskBuf.IntegerInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image2[i][j] == oldConstant ? newConstant : Image2[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }

    public static double[][] ReplaceDoubleGrayIMGBuf(double[][] Image2, double oldConstant, double newConstant) throws ImageGSException {
        double[][] TargetGrayIMGBuf = null;
        if (Image2 == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0.0 || oldConstant > 255.0) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0.0 || newConstant > 255.0) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image2);
            int width = GetSizeIMG.getWidth(Image2);
            TargetGrayIMGBuf = InitMaskBuf.DoubleInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image2[i][j] == oldConstant ? newConstant : Image2[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }
}

