/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Util.InsertionSort;

public class QuickSort {
    private static final int BASE_LENGTH = 64;
    private final int MAX_N = 10000;

    private static void SWAP(double[] data, int x, int y) {
        double temp = data[x];
        data[x] = data[y];
        data[y] = temp;
    }

    private static int partition(int n, double[] data, int first) {
        int last = first + n - 1;
        QuickSort.SWAP(data, first + 1, (n - 1) / 2 + first);
        if (data[first + 1] > data[last]) {
            QuickSort.SWAP(data, first + 1, last);
        }
        if (data[first] > data[last]) {
            QuickSort.SWAP(data, first, last);
        }
        if (data[first + 1] > data[first]) {
            QuickSort.SWAP(data, first + 1, first);
        }
        double pivot_value = data[first];
        int left = first + 1;
        int right = last;
        while (true) {
            if (data[++left] < pivot_value) {
                continue;
            }
            while (data[--right] > pivot_value) {
            }
            if (right < left) break;
            QuickSort.SWAP(data, left, right);
        }
        data[first] = data[right];
        data[right] = pivot_value;
        return right;
    }

    public static void seq_quicksort(int n, double[] data, int first) {
        if (n <= 64) {
            InsertionSort.InsertSort(n, data, first);
        } else {
            int pivot = QuickSort.partition(n, data, first);
            QuickSort.seq_quicksort(pivot - first, data, first);
            QuickSort.seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
        }
    }

    private static void SWAP(int[] data, int x, int y) {
        int temp = data[x];
        data[x] = data[y];
        data[y] = temp;
    }

    private static int partition(int n, int[] data, int first) {
        int last = first + n - 1;
        QuickSort.SWAP(data, first + 1, (n - 1) / 2 + first);
        if (data[first + 1] > data[last]) {
            QuickSort.SWAP(data, first + 1, last);
        }
        if (data[first] > data[last]) {
            QuickSort.SWAP(data, first, last);
        }
        if (data[first + 1] > data[first]) {
            QuickSort.SWAP(data, first + 1, first);
        }
        int pivot_value = data[first];
        int left = first + 1;
        int right = last;
        while (true) {
            if (data[++left] < pivot_value) {
                continue;
            }
            while (data[--right] > pivot_value) {
            }
            if (right < left) break;
            QuickSort.SWAP(data, left, right);
        }
        data[first] = data[right];
        data[right] = pivot_value;
        return right;
    }

    public static void seq_quicksort(int n, int[] data, int first) {
        if (n <= 64) {
            InsertionSort.InsertSort(n, data, first);
        } else {
            int pivot = QuickSort.partition(n, data, first);
            QuickSort.seq_quicksort(pivot - first, data, first);
            QuickSort.seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
        }
    }

    private static void SWAP(short[] data, int x, int y) {
        short temp = data[x];
        data[x] = data[y];
        data[y] = temp;
    }

    private static int partition(int n, short[] data, int first) {
        int last = first + n - 1;
        QuickSort.SWAP(data, first + 1, (n - 1) / 2 + first);
        if (data[first + 1] > data[last]) {
            QuickSort.SWAP(data, first + 1, last);
        }
        if (data[first] > data[last]) {
            QuickSort.SWAP(data, first, last);
        }
        if (data[first + 1] > data[first]) {
            QuickSort.SWAP(data, first + 1, first);
        }
        short pivot_value = data[first];
        int left = first + 1;
        int right = last;
        while (true) {
            if (data[++left] < pivot_value) {
                continue;
            }
            while (data[--right] > pivot_value) {
            }
            if (right < left) break;
            QuickSort.SWAP(data, left, right);
        }
        data[first] = data[right];
        data[right] = pivot_value;
        return right;
    }

    public static void seq_quicksort(int n, short[] data, int first) {
        if (n <= 64) {
            InsertionSort.InsertSort(n, data, first);
        } else {
            int pivot = QuickSort.partition(n, data, first);
            QuickSort.seq_quicksort(pivot - first, data, first);
            QuickSort.seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
        }
    }
}

