/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;
import java.awt.image.BufferedImage;

public class Channel2BufferedImage {
    private int alpha = -16777216;
    private BufferedImage bi = null;

    public void gray(short[][] grayChannel) throws ImageGSException {
        int height = GetSizeIMG.getHeight(grayChannel);
        int width = GetSizeIMG.getWidth(grayChannel);
        this.gray(grayChannel, height, width);
    }

    public void gray(short[][] grayChannel, int height, int width) {
        this.color(grayChannel, grayChannel, grayChannel, height, width);
    }

    public void color(short[][] RedChannel, short[][] GreenChannel, short[][] BlueChannel) throws ImageGSException {
        int red_height = GetSizeIMG.getHeight(RedChannel);
        int red_width = GetSizeIMG.getWidth(RedChannel);
        int green_height = GetSizeIMG.getHeight(GreenChannel);
        int green_width = GetSizeIMG.getWidth(GreenChannel);
        int blue_height = GetSizeIMG.getHeight(BlueChannel);
        int blue_width = GetSizeIMG.getWidth(BlueChannel);
        if (red_height != green_height || green_height != blue_height) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The each size of channels not equal.");
        }
        this.color(RedChannel, GreenChannel, BlueChannel, red_height, red_width);
    }

    public void color(short[][] RedChannel, short[][] GreenChannel, short[][] BlueChannel, int height, int width) {
        try {
            this.bi = new BufferedImage(width, height, 1);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    short r = RedChannel[i][j];
                    short g = GreenChannel[i][j];
                    short b = BlueChannel[i][j];
                    this.bi.setRGB(j, i, this.packRGB(r, g, b));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        if (this.bi == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "BufferedImage is null");
        }
        return this.bi;
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }
}

