/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.InitMaskBuf;
import java.awt.image.BufferedImage;

public class BufferedImage2Channel {
    private short[][] GrayChannel = null;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private int height = 0;
    private int width = 0;
    private BufferedImage bi;

    public void gray(BufferedImage bi) throws ImageGSException {
        this.bi = bi;
        this.run();
    }

    public void color(BufferedImage bi) throws ImageGSException {
        this.bi = bi;
        this.run();
    }

    public void all(BufferedImage bi) throws ImageGSException {
        this.bi = bi;
        this.run();
    }

    public short[][] getRedChannel() throws ImageGSException {
        if (this.RedChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >>  " + "The Red channel is null");
        }
        return this.RedChannel;
    }

    public short[][] getGreenChannel() throws ImageGSException {
        if (this.GreenChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >>  " + "The Green channel is null");
        }
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() throws ImageGSException {
        if (this.BlueChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >>  " + "The Blue channel is null");
        }
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() throws ImageGSException {
        if (this.GrayChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >>  " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        return this.GrayChannel;
    }

    private void run() throws ImageGSException {
        if (this.bi == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "BufferedImage is null");
        }
        if (this.bi.getType() != 1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Type of BufferedImage is not TYPE_INT_RGB");
        }
        try {
            this.height = this.bi.getHeight();
            this.width = this.bi.getWidth();
            if (this.GrayChannel == null) {
                this.GrayChannel = InitMaskBuf.ShortInitMask(this.height, this.width);
            }
            if (this.RedChannel == null) {
                this.RedChannel = InitMaskBuf.ShortInitMask(this.height, this.width);
            }
            if (this.GreenChannel == null) {
                this.GreenChannel = InitMaskBuf.ShortInitMask(this.height, this.width);
            }
            if (this.BlueChannel == null) {
                this.BlueChannel = InitMaskBuf.ShortInitMask(this.height, this.width);
            }
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    this.RedChannel[i][j] = this.getR(j, i);
                    this.GreenChannel[i][j] = this.getG(j, i);
                    this.BlueChannel[i][j] = this.getB(j, i);
                    this.GrayChannel[i][j] = (short)((double)this.getR(j, i) * 0.299 + (double)this.getG(j, i) * 0.587 + (double)this.getB(j, i) * 0.114);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    private short getR(int x, int y) {
        return (short)this.bi.getColorModel().getRed(this.bi.getRGB(x, y));
    }

    private short getG(int x, int y) {
        return (short)this.bi.getColorModel().getGreen(this.bi.getRGB(x, y));
    }

    private short getB(int x, int y) {
        return (short)this.bi.getColorModel().getBlue(this.bi.getRGB(x, y));
    }
}

