package map;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.BasicStroke;
import java.awt.geom.Ellipse2D;

public class City {
	
	public String idx;
	public String locName;
	public Color color;
	public BasicStroke stroke;
	public double x;
	public double y;
	public double w;
	public double h;
	public boolean visible;
	
	// Constructor
	public City(String index, String localName, double cx,
			double cy) {
		idx = index;
		locName = localName;
		color = Color.CYAN;
		stroke = new BasicStroke(4.0f);
		x = cx;
		y = cy;
		w = 16.0;
		h = 16.0;
		visible = false;
	}
	
	public void setVisible(boolean b) {
		visible = b;
	}
	
	public boolean isVisible() {
		return visible;
	}
	
	public String getIdx() {
		return idx;
	}
	
	public String getLocName() {
		return locName;
	}
	
	public void setStroke(BasicStroke s) {
		stroke = s;
	}
	
	public BasicStroke getStroke() {
		return stroke;
	}
	
	public void setColor(Color p) {
		color = p;
	}
	
	public Color getColor() {
		return color;
	}
	
	public void setCoordinate(double cx, double cy, double width, double height) {
		x = cx;
		y = cy;
		w = width;
		h = height;
	}
	
	// 忡  ׸.
	public void drawCircle(Graphics2D g) {
		g.setStroke(stroke);
		g.setColor(color.brighter());
		g.fill(new Ellipse2D.Double(x + 1, y + 1, w - 2, h - 2));
		g.setColor(color.darker());
		g.draw(new Ellipse2D.Double(x, y, w, h));
	}
	
} // end class City