/**
 * Class Name	: ResourceBundleManager
 * Description	: String ޽ óϴ Ŭ
 * Date 				: 2003/06/07
 * Author			: CheolWoo, kim, Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/06/07 first created.
 */

/*
 * ResourceBundleManager  ҽ  ֽ () ö쾾 帳ϴ.
 */
 
package com.conv2.imageGS.Util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * i18n ϱ  String message  Ŭ. <p>
 * 
 * Ű ϰ Ǹ,  Ű ϴ LocalString.properties  ã´. <br>
 * Ŀ imageGS API ErrorMsg Ŭ  properties  ϰ  , <br>
 *  Ŭ ̿Ͽ ϸ  ̴. <p>
 * 
 * TestResourceBundleManager.java ϶. <p>
 * 
 * @author Chul-Woo, Kim
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public class ResourceBundleManager 
{
 	private static HashMap managers = new HashMap();
  
	private ResourceBundle bundle;
  
	private ResourceBundleManager( String packageName ) 
	{
		String bundleName = packageName + ".LocalStrings";
		bundle = ResourceBundle.getBundle( bundleName );
	}
  
	public String getString( String key ) 
	{
		if( key == null || key.equals( "" ) ) 
		{
 			throw new NullPointerException( "key is null" );
 		}
    
		String str = null;
		try 
		{
			str = bundle.getString( key );
		} 
		catch( MissingResourceException e ) 
		{
			str = "Cannot find message associated with key '" + key + "'";
		}
    
		return str;
	}
  
	public String getString( String key, Object[] args ) 
	{
    
		String iString = null;
		String value = getString( key );

		// this check for the runtime exception is some pre 1.1.6
		// VM's don't do an automatic toString() on the passed in
		// objects and barf out
		try 
		{
			// ensure the arguments are not null so pre 1.2 VM's don't barf
			Object nonNullArgs[] = args;
			
			for( int i = 0; i < args.length; i++ ) 
			{
				if( args[i] == null ) 
				{
					if( nonNullArgs == args ) nonNullArgs=(Object[])args.clone();
					nonNullArgs[i] = "null";
        		}
      		}
      		
			iString = MessageFormat.format( value, nonNullArgs );
		} 
		catch( IllegalArgumentException e ) 
		{
			StringBuffer buf = new StringBuffer();
 			buf.append( value );
		
			for( int i = 0; i < args.length; i++ ) 
			{
				buf.append( " arg[" + i + "]=" + args[i] );
			}
		
			iString = buf.toString();
		}
		return iString;
		
	}
  
	public String getString( String key, Object arg1 ) 
	{
		Object[] args = new Object[] { arg1 };
		return getString( key, args );
	}
  
	public String getString( String key, Object arg1, Object arg2 ) 
	{
		Object[] args = new Object[] { arg1, arg2 };
		return getString( key, args );
	}
  
	public String getString( String key, Object arg1, Object arg2, Object arg3 ) 
	{
		Object[] args = new Object[] { arg1, arg2, arg3 };
		return getString( key, args );
	}
  
	public static synchronized ResourceBundleManager getManager( String packageName ) 
	{
		ResourceBundleManager manager = (ResourceBundleManager)managers.get( packageName );
    
		if( manager == null ) 
		{
			manager = new ResourceBundleManager( packageName );
			managers.put( packageName, manager );
		}
    
		return manager;
	}
}
