/**
 * Class Name	: QuickSort
 * Description	: Quick sort  Ŭ
 * Date 				: 2002/09/07
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/07 first created.
 */

package com.conv2.imageGS.Util;

/**
 * Quick sort, double / Integer / sort Ÿ  迭 Ʈ   Ѵ.
 * 
 * @author Yuanshan Guo
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 *
 */
public class QuickSort
{
	private static final int BASE_LENGTH = 64;
	private final int MAX_N = 10000;

	/**
	 * quick sort with double type
	 */
	
	private static void SWAP(double data[], int x, int y)
	{
		double temp;
		
		temp = data[x];
		data[x] = data[y];
		data[y] = temp;
	}
	
	private static int partition(int n, double data[], int first)
	{
		double pivot_value;
		int left, right;
		int last;
		
		last = first + n - 1;
		
		SWAP(data, first + 1, (n - 1) / 2 + first);
		
		if (data[first + 1] > data[last])
		  SWAP(data, first + 1, last);
		  
		if (data[first] > data[last])
		  SWAP(data, first, last);
		  
		if (data[first + 1] > data[first])
		  SWAP(data, first + 1, first);
		
		pivot_value = data[first];
		left = first + 1; 
		right = last;
		
		while (true) {
			
			do 
				left++; 
			while (data[left] < pivot_value);
		
			do 
				right--; 
			while (data[right] > pivot_value);
		  
			if (right < left) break;
			
			SWAP(data, left, right);
			
		}
		
		data[first] = data[right];
		data[right] = pivot_value;
		
		return right;
	}

	/**
	 * double[] Ÿ  迭 Ѵ.
	 * 
	 * @param	n	ش 迭 
	 * @param	data[]	double type 迭 
	 * @param	first	ġ  (default : 0)
	 * @return	
	 */
	public static void seq_quicksort(int n, double data[], int first)
	{
		int i;
		
		if (n <= BASE_LENGTH)
		{
			InsertionSort.InsertSort(n, data, first);
		}
		else 
		{
			int pivot = partition(n, data, first);
		  
			seq_quicksort(pivot - first, data, first);
			seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
		}
	}
	
	
	/**
	 * quick sort with integer type
	 */
	
	private static void SWAP(int data[], int x, int y)
	{
		int temp;
		
		temp = data[x];
		data[x] = data[y];
		data[y] = temp;
	}
	
	private static int partition(int n, int data[], int first)
	{
		int pivot_value;
		int left, right;
		int last;
		
		last = first + n - 1;
		
		SWAP(data, first + 1, (n - 1) / 2 + first);
		
		if (data[first + 1] > data[last])
		  SWAP(data, first + 1, last);
		  
		if (data[first] > data[last])
		  SWAP(data, first, last);
		  
		if (data[first + 1] > data[first])
		  SWAP(data, first + 1, first);
		
		pivot_value = data[first];
		left = first + 1; 
		right = last;
		
		while (true) {
			
			do 
				left++; 
			while (data[left] < pivot_value);
		
			do 
				right--; 
			while (data[right] > pivot_value);
		  
			if (right < left) break;
			
			SWAP(data, left, right);
			
		}
		
		data[first] = data[right];
		data[right] = pivot_value;
		
		return right;
	}

	/**
	 * integer [] Ÿ  迭 Ѵ.
	 * 
	 * @param	n	ش 迭 
	 * @param	data[]	integer type 迭 
	 * @param	first	ġ  (default : 0)
	 * @return	
	 */
	public static void seq_quicksort(int n, int data[], int first)
	{
		int i;
		
		if (n <= BASE_LENGTH)
		{
			InsertionSort.InsertSort(n, data, first);
		}
		else 
		{
			int pivot = partition(n, data, first);
		  
			seq_quicksort(pivot - first, data, first);
			seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
		}
	}

	/**
	 * quick sort with short type
	 */
	
	private static void SWAP(short data[], int x, int y)
	{
		short temp;
		
		temp = data[x];
		data[x] = data[y];
		data[y] = temp;
	}
	
	private static int partition(int n, short data[], int first)
	{
		short pivot_value;
		int left, right;
		int last;
		
		last = first + n - 1;
		
		SWAP(data, first + 1, (n - 1) / 2 + first);
		
		if (data[first + 1] > data[last])
		  SWAP(data, first + 1, last);
		  
		if (data[first] > data[last])
		  SWAP(data, first, last);
		  
		if (data[first + 1] > data[first])
		  SWAP(data, first + 1, first);
		
		pivot_value = data[first];
		left = first + 1; 
		right = last;
		
		while (true) {
			
			do 
				left++; 
			while (data[left] < pivot_value);
		
			do 
				right--; 
			while (data[right] > pivot_value);
		  
			if (right < left) break;
			
			SWAP(data, left, right);
			
		}
		
		data[first] = data[right];
		data[right] = pivot_value;
		
		return right;
	}

	/**
	 * short [] Ÿ  迭 Ѵ.
	 * 
	 * @param	n	ش 迭 
	 * @param	data[]	integer type 迭 
	 * @param	first	ġ (default : 0)
	 * @return	
	 */
	public static void seq_quicksort(int n, short data[], int first)
	{
		int i;
		
		if (n <= BASE_LENGTH)
		{
			InsertionSort.InsertSort(n, data, first);
		}
		else 
		{
			int pivot = partition(n, data, first);
		  
			seq_quicksort(pivot - first, data, first);
			seq_quicksort(n - (pivot - first) - 1, data, pivot + 1);
		}
	}  
}
   
