/**
 * Class Name	: FileLock
 * Description	: ش Ͽ lock/unlock 
 * Date 				: 2003/01/13
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/01/13 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.nio.channels.*;
import java.io.*;

/**
 *   ɰ, ϴ  Ŭ ( : JDK 1.4 ̻󿡸 ȴ.) <p>
 * 
 * [  ] <p>
 * 
 * 1) ش Ͽ  ɸ, ٸ   ش   ϶ <br>
 * file.canWrite() 񽺹ϰ   ִ.<p>
 * 
 * 2) Ӱ   <p>
 * 
 *    canWrite() ޼ҵ忡   ŷ  ʴ´.<br>
 * ǻ JDK 1.3 Ͽ     ̴.<br>
 * ׷Ƿ JDK 1.4 ̻  ִٸ nio Ű ִ  Ȱϱ ٶ. <p>
 *   
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public class LockFile
{
	private static FileChannel channel;
	private static File file;
	private static FileLock lock;
			
	/**
	 * ش  lock file Ѵ.
	 * 
	 * @param lockFile   ϸ
	 * @exception lockFile ̰ų   
	 */
	public LockFile(String lockFile) throws ImageGSException
	{
		if(lockFile == null) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " +
				ErrorMsg.ERRORUSERVALUEISNULL);
		}
		
		try 
		{
	        file = new File(lockFile);
	        channel = new RandomAccessFile(file, "rw").getChannel();
		}
		catch(IOException e) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage());	
		}
	}
	
	/**
	 * lock Ǵ. 
	 * 
	 * @return  : true /  : false
	 */
	public boolean lock()
	{
		boolean flag = true;
		
		try
		{
			lock = channel.lock();
		} 
		catch (OverlappingFileLockException e1) 
		{
			flag = false;	
		}
		catch(IOException e)
		{
			flag = false;	
		}
		
		return flag;
	}

	/**
	 * lock õѴ. ó lock() ߴٸ  trylock() ߿  õ  Ѵ.
	 * 
	 * @return  : true /  : false
	 */	
	public boolean trylock()
	{
		boolean flag = true;
		
		try
		{
			if(channel == null) 
			{
				flag = false;
			}
			else 
			{
				lock = channel.tryLock();
			}	
		}
		catch (OverlappingFileLockException e1) 
		{
			flag = false;	
		}
		catch (IOException e2)
		{
			flag = false;	
		}
				
		return flag;
	}
	
	/**
	 * lock Ѵ.   unlock lock file Ѵٴ ̴.
	 * 
	 * @return  : true /  : false
	 * @exception ش lock file ü  
	 */
	public boolean unlock() throws ImageGSException
	{
		boolean flag = true;
		
		try
		{
			if(lock != null) 
			{ 
				lock.release();
				lock = null;
			}
			
			if(channel != null)
			{
				channel.close();
				channel = null;
			}
			
			if(file == null)
			{
				throw new ImageGSException(this.getClass().getName() + " >> " +
					ErrorMsg.ERRORUSERVALUEISNULL);
			}
			
			// .lock  Ѵ.
			file.delete();	
			file = null;
			channel = null;
		}
		catch (IOException e)
		{
			flag = false;	
		}
		
		return flag;
	}
}
